@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Properties of the storage task assignment.
 * @property description Text that describes the purpose of the storage task assignment
 * @property enabled Whether the storage task assignment is enabled or not
 * @property executionContext The storage task assignment execution context
 * @property provisioningState Represents the provisioning state of the storage task assignment.
 * @property report The storage task assignment report
 * @property runStatus Run status of storage task assignment
 * @property taskId Id of the corresponding storage task
 */
public data class StorageTaskAssignmentPropertiesResponse(
    public val description: String,
    public val enabled: Boolean,
    public val executionContext: StorageTaskAssignmentExecutionContextResponse,
    public val provisioningState: String,
    public val report: StorageTaskAssignmentReportResponse,
    public val runStatus: StorageTaskReportPropertiesResponse? = null,
    public val taskId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.StorageTaskAssignmentPropertiesResponse): StorageTaskAssignmentPropertiesResponse = StorageTaskAssignmentPropertiesResponse(
            description = javaType.description(),
            enabled = javaType.enabled(),
            executionContext = javaType.executionContext().let({ args0 ->
                com.pulumi.azurenative.storage.kotlin.outputs.StorageTaskAssignmentExecutionContextResponse.Companion.toKotlin(args0)
            }),
            provisioningState = javaType.provisioningState(),
            report = javaType.report().let({ args0 ->
                com.pulumi.azurenative.storage.kotlin.outputs.StorageTaskAssignmentReportResponse.Companion.toKotlin(args0)
            }),
            runStatus = javaType.runStatus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.StorageTaskReportPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            taskId = javaType.taskId(),
        )
    }
}
