@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Storage task execution report for a run instance.
 * @property finishTime End time of the run instance. Filter options such as startTime gt '2023-06-26T20:51:24.4494016Z' and other comparison operators can be used as described for DateTime properties in https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators
 * @property objectFailedCount Total number of objects where task operation failed when was attempted. Filter options such as objectFailedCount eq 0 and other comparison operators can be used as described for Numerical properties in https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators
 * @property objectsOperatedOnCount Total number of objects that meet the storage tasks condition and were operated upon. Filter options such as objectsOperatedOnCount ge 100 and other comparison operators can be used as described for Numerical properties in https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators
 * @property objectsSucceededCount Total number of objects where task operation succeeded when was attempted.Filter options such as objectsSucceededCount gt 150 and other comparison operators can be used as described for Numerical properties in https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators
 * @property objectsTargetedCount Total number of objects that meet the condition as defined in the storage task assignment execution context. Filter options such as objectsTargetedCount gt 50 and other comparison operators can be used as described for Numerical properties in https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators
 * @property runResult Represents the overall result of the execution for the run instance
 * @property runStatusEnum Represents the status of the execution.
 * @property runStatusError Well known Azure Storage error code that represents the error encountered during execution of the run instance.
 * @property startTime Start time of the run instance. Filter options such as startTime gt '2023-06-26T20:51:24.4494016Z' and other comparison operators can be used as described for DateTime properties in https://learn.microsoft.com/en-us/rest/api/storageservices/querying-tables-and-entities#supported-comparison-operators
 * @property storageAccountId Represents the Storage Account Id where the storage task definition was applied and executed.
 * @property summaryReportPath Full path to the verbose report stored in the reporting container as specified in the assignment execution context for the storage account.
 * @property taskAssignmentId Represents the Storage Task Assignment Id associated with the storage task that provided an execution context.
 * @property taskId Storage Task Arm Id.
 * @property taskVersion Storage Task Version
 */
public data class StorageTaskReportPropertiesResponse(
    public val finishTime: String,
    public val objectFailedCount: String,
    public val objectsOperatedOnCount: String,
    public val objectsSucceededCount: String,
    public val objectsTargetedCount: String,
    public val runResult: String,
    public val runStatusEnum: String,
    public val runStatusError: String,
    public val startTime: String,
    public val storageAccountId: String,
    public val summaryReportPath: String,
    public val taskAssignmentId: String,
    public val taskId: String,
    public val taskVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.StorageTaskReportPropertiesResponse): StorageTaskReportPropertiesResponse = StorageTaskReportPropertiesResponse(
            finishTime = javaType.finishTime(),
            objectFailedCount = javaType.objectFailedCount(),
            objectsOperatedOnCount = javaType.objectsOperatedOnCount(),
            objectsSucceededCount = javaType.objectsSucceededCount(),
            objectsTargetedCount = javaType.objectsTargetedCount(),
            runResult = javaType.runResult(),
            runStatusEnum = javaType.runStatusEnum(),
            runStatusError = javaType.runStatusError(),
            startTime = javaType.startTime(),
            storageAccountId = javaType.storageAccountId(),
            summaryReportPath = javaType.summaryReportPath(),
            taskAssignmentId = javaType.taskAssignmentId(),
            taskId = javaType.taskId(),
            taskVersion = javaType.taskVersion(),
        )
    }
}
