@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Table Access Policy Properties Object.
 * @property expiryTime Expiry time of the access policy
 * @property permission Required. List of abbreviated permissions. Supported permission values include 'r','a','u','d'
 * @property startTime Start time of the access policy
 */
public data class TableAccessPolicyResponse(
    public val expiryTime: String? = null,
    public val permission: String,
    public val startTime: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.TableAccessPolicyResponse): TableAccessPolicyResponse = TableAccessPolicyResponse(
            expiryTime = javaType.expiryTime().map({ args0 -> args0 }).orElse(null),
            permission = javaType.permission(),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
