@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A tag of the LegalHold of a blob container.
 * @property objectIdentifier Returns the Object ID of the user who added the tag.
 * @property tag The tag value.
 * @property tenantId Returns the Tenant ID that issued the token for the user who added the tag.
 * @property timestamp Returns the date and time the tag was added.
 * @property upn Returns the User Principal Name of the user who added the tag.
 */
public data class TagPropertyResponse(
    public val objectIdentifier: String,
    public val tag: String,
    public val tenantId: String,
    public val timestamp: String,
    public val upn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.TagPropertyResponse): TagPropertyResponse = TagPropertyResponse(
            objectIdentifier = javaType.objectIdentifier(),
            tag = javaType.tag(),
            tenantId = javaType.tenantId(),
            timestamp = javaType.timestamp(),
            upn = javaType.upn(),
        )
    }
}
