@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The trigger parameters update for the storage task assignment execution
 * @property endBy When to end task execution. This is a required field when ExecutionTrigger.properties.type is 'OnSchedule'; this property should not be present when ExecutionTrigger.properties.type is 'RunOnce'
 * @property interval Run interval of task execution. This is a required field when ExecutionTrigger.properties.type is 'OnSchedule'; this property should not be present when ExecutionTrigger.properties.type is 'RunOnce'
 * @property intervalUnit Run interval unit of task execution. This is a required field when ExecutionTrigger.properties.type is 'OnSchedule'; this property should not be present when ExecutionTrigger.properties.type is 'RunOnce'
 * @property startFrom When to start task execution. This is a required field when ExecutionTrigger.properties.type is 'OnSchedule'; this property should not be present when ExecutionTrigger.properties.type is 'RunOnce'
 * @property startOn When to start task execution. This is an optional field when ExecutionTrigger.properties.type is 'RunOnce'; this property should not be present when ExecutionTrigger.properties.type is 'OnSchedule'
 */
public data class TriggerParametersResponse(
    public val endBy: String? = null,
    public val interval: Int? = null,
    public val intervalUnit: String? = null,
    public val startFrom: String? = null,
    public val startOn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.TriggerParametersResponse): TriggerParametersResponse = TriggerParametersResponse(
            endBy = javaType.endBy().map({ args0 -> args0 }).orElse(null),
            interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
            intervalUnit = javaType.intervalUnit().map({ args0 -> args0 }).orElse(null),
            startFrom = javaType.startFrom().map({ args0 -> args0 }).orElse(null),
            startOn = javaType.startOn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
