@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storageactions.kotlin

import com.pulumi.azurenative.storageactions.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.storageactions.kotlin.outputs.StorageTaskActionResponse
import com.pulumi.azurenative.storageactions.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.storageactions.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.storageactions.kotlin.outputs.StorageTaskActionResponse.Companion.toKotlin as storageTaskActionResponseToKotlin
import com.pulumi.azurenative.storageactions.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [StorageTask].
 */
@PulumiTagMarker
public class StorageTaskResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StorageTaskArgs = StorageTaskArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StorageTaskArgsBuilder.() -> Unit) {
        val builder = StorageTaskArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StorageTask {
        val builtJavaResource =
            com.pulumi.azurenative.storageactions.StorageTask(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return StorageTask(builtJavaResource)
    }
}

/**
 * Represents Storage Task.
 * Azure REST API version: 2023-01-01.
 * ## Example Usage
 * ### PutStorageTask
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageTask = new AzureNative.StorageActions.StorageTask("storageTask", new()
 *     {
 *         Action = new AzureNative.StorageActions.Inputs.StorageTaskActionArgs
 *         {
 *             Else = new AzureNative.StorageActions.Inputs.ElseConditionArgs
 *             {
 *                 Operations = new[]
 *                 {
 *                     new AzureNative.StorageActions.Inputs.StorageTaskOperationArgs
 *                     {
 *                         Name = AzureNative.StorageActions.StorageTaskOperationName.DeleteBlob,
 *                         OnFailure = AzureNative.StorageActions.OnFailure.@Break,
 *                         OnSuccess = AzureNative.StorageActions.OnSuccess.@Continue,
 *                     },
 *                 },
 *             },
 *             If = new AzureNative.StorageActions.Inputs.IfConditionArgs
 *             {
 *                 Condition = "[[equals(AccessTier, 'Cool')]]",
 *                 Operations = new[]
 *                 {
 *                     new AzureNative.StorageActions.Inputs.StorageTaskOperationArgs
 *                     {
 *                         Name = AzureNative.StorageActions.StorageTaskOperationName.SetBlobTier,
 *                         OnFailure = AzureNative.StorageActions.OnFailure.@Break,
 *                         OnSuccess = AzureNative.StorageActions.OnSuccess.@Continue,
 *                         Parameters =
 *                         {
 *                             { "tier", "Hot" },
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         Description = "My Storage task",
 *         Enabled = true,
 *         Identity = new AzureNative.StorageActions.Inputs.ManagedServiceIdentityArgs
 *         {
 *             Type = AzureNative.StorageActions.ManagedServiceIdentityType.SystemAssigned,
 *         },
 *         Location = "westus",
 *         ResourceGroupName = "res4228",
 *         StorageTaskName = "mytask1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storageactions/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storageactions.NewStorageTask(ctx, "storageTask", &storageactions.StorageTaskArgs{
 * 			Action: &storageactions.StorageTaskActionArgs{
 * 				Else: &storageactions.ElseConditionArgs{
 * 					Operations: storageactions.StorageTaskOperationArray{
 * 						&storageactions.StorageTaskOperationArgs{
 * 							Name:      pulumi.String(storageactions.StorageTaskOperationNameDeleteBlob),
 * 							OnFailure: storageactions.OnFailureBreak,
 * 							OnSuccess: storageactions.OnSuccessContinue,
 * 						},
 * 					},
 * 				},
 * 				If: &storageactions.IfConditionArgs{
 * 					Condition: pulumi.String("[[equals(AccessTier, 'Cool')]]"),
 * 					Operations: storageactions.StorageTaskOperationArray{
 * 						&storageactions.StorageTaskOperationArgs{
 * 							Name:      pulumi.String(storageactions.StorageTaskOperationNameSetBlobTier),
 * 							OnFailure: storageactions.OnFailureBreak,
 * 							OnSuccess: storageactions.OnSuccessContinue,
 * 							Parameters: pulumi.StringMap{
 * 								"tier": pulumi.String("Hot"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Description: pulumi.String("My Storage task"),
 * 			Enabled:     pulumi.Bool(true),
 * 			Identity: &storageactions.ManagedServiceIdentityArgs{
 * 				Type: pulumi.String(storageactions.ManagedServiceIdentityTypeSystemAssigned),
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("res4228"),
 * 			StorageTaskName:   pulumi.String("mytask1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storageactions.StorageTask;
 * import com.pulumi.azurenative.storageactions.StorageTaskArgs;
 * import com.pulumi.azurenative.storageactions.inputs.StorageTaskActionArgs;
 * import com.pulumi.azurenative.storageactions.inputs.ElseConditionArgs;
 * import com.pulumi.azurenative.storageactions.inputs.IfConditionArgs;
 * import com.pulumi.azurenative.storageactions.inputs.ManagedServiceIdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageTask = new StorageTask("storageTask", StorageTaskArgs.builder()
 *             .action(StorageTaskActionArgs.builder()
 *                 .else_(ElseConditionArgs.builder()
 *                     .operations(StorageTaskOperationArgs.builder()
 *                         .name("DeleteBlob")
 *                         .onFailure("break")
 *                         .onSuccess("continue")
 *                         .build())
 *                     .build())
 *                 .if_(IfConditionArgs.builder()
 *                     .condition("[[equals(AccessTier, 'Cool')]]")
 *                     .operations(StorageTaskOperationArgs.builder()
 *                         .name("SetBlobTier")
 *                         .onFailure("break")
 *                         .onSuccess("continue")
 *                         .parameters(Map.of("tier", "Hot"))
 *                         .build())
 *                     .build())
 *                 .build())
 *             .description("My Storage task")
 *             .enabled(true)
 *             .identity(ManagedServiceIdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .location("westus")
 *             .resourceGroupName("res4228")
 *             .storageTaskName("mytask1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storageactions:StorageTask mytask1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageActions/storageTasks/{storageTaskName}
 * ```
 */
public class StorageTask internal constructor(
    override val javaResource: com.pulumi.azurenative.storageactions.StorageTask,
) : KotlinCustomResource(javaResource, StorageTaskMapper) {
    /**
     * The storage task action that is executed
     */
    public val action: Output<StorageTaskActionResponse>
        get() = javaResource.action().applyValue({ args0 ->
            args0.let({ args0 ->
                storageTaskActionResponseToKotlin(args0)
            })
        })

    /**
     * The creation date and time of the storage task in UTC.
     */
    public val creationTimeInUtc: Output<String>
        get() = javaResource.creationTimeInUtc().applyValue({ args0 -> args0 })

    /**
     * Text that describes the purpose of the storage task
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Storage Task is enabled when set to true and disabled when set to false
     */
    public val enabled: Output<Boolean>
        get() = javaResource.enabled().applyValue({ args0 -> args0 })

    /**
     * The managed service identity of the resource.
     */
    public val identity: Output<ManagedServiceIdentityResponse>
        get() = javaResource.identity().applyValue({ args0 ->
            args0.let({ args0 ->
                managedServiceIdentityResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Represents the provisioning state of the storage task.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Storage task version.
     */
    public val taskVersion: Output<Double>
        get() = javaResource.taskVersion().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object StorageTaskMapper : ResourceMapper<StorageTask> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storageactions.StorageTask::class == javaResource::class

    override fun map(javaResource: Resource): StorageTask = StorageTask(
        javaResource as
            com.pulumi.azurenative.storageactions.StorageTask,
    )
}

/**
 * @see [StorageTask].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StorageTask].
 */
public suspend fun storageTask(name: String, block: suspend StorageTaskResourceBuilder.() -> Unit): StorageTask {
    val builder = StorageTaskResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StorageTask].
 * @param name The _unique_ name of the resulting resource.
 */
public fun storageTask(name: String): StorageTask {
    val builder = StorageTaskResourceBuilder()
    builder.name(name)
    return builder.build()
}
