@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storageactions.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The operation to be performed on the object.
 */
public enum class StorageTaskOperationName(
    public val javaValue: com.pulumi.azurenative.storageactions.enums.StorageTaskOperationName,
) : ConvertibleToJava<com.pulumi.azurenative.storageactions.enums.StorageTaskOperationName> {
    SetBlobTier(com.pulumi.azurenative.storageactions.enums.StorageTaskOperationName.SetBlobTier),
    SetBlobTags(com.pulumi.azurenative.storageactions.enums.StorageTaskOperationName.SetBlobTags),
    SetBlobImmutabilityPolicy(com.pulumi.azurenative.storageactions.enums.StorageTaskOperationName.SetBlobImmutabilityPolicy),
    SetBlobLegalHold(com.pulumi.azurenative.storageactions.enums.StorageTaskOperationName.SetBlobLegalHold),
    SetBlobExpiry(com.pulumi.azurenative.storageactions.enums.StorageTaskOperationName.SetBlobExpiry),
    DeleteBlob(com.pulumi.azurenative.storageactions.enums.StorageTaskOperationName.DeleteBlob),
    UndeleteBlob(com.pulumi.azurenative.storageactions.enums.StorageTaskOperationName.UndeleteBlob),
    ;

    override fun toJava(): com.pulumi.azurenative.storageactions.enums.StorageTaskOperationName =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storageactions.enums.StorageTaskOperationName): StorageTaskOperationName =
            StorageTaskOperationName.values().first { it.javaValue == javaType }
    }
}
