@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storageactions.kotlin.inputs

import com.pulumi.azurenative.storageactions.inputs.IfConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The if block of storage task operation
 * @property condition Condition predicate to evaluate each object. See https://aka.ms/storagetaskconditions for valid properties and operators.
 * @property operations List of operations to execute when the condition predicate satisfies.
 */
public data class IfConditionArgs(
    public val condition: Output<String>,
    public val operations: Output<List<StorageTaskOperationArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.storageactions.inputs.IfConditionArgs> {
    override fun toJava(): com.pulumi.azurenative.storageactions.inputs.IfConditionArgs =
        com.pulumi.azurenative.storageactions.inputs.IfConditionArgs.builder()
            .condition(condition.applyValue({ args0 -> args0 }))
            .operations(
                operations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IfConditionArgs].
 */
@PulumiTagMarker
public class IfConditionArgsBuilder internal constructor() {
    private var condition: Output<String>? = null

    private var operations: Output<List<StorageTaskOperationArgs>>? = null

    /**
     * @param value Condition predicate to evaluate each object. See https://aka.ms/storagetaskconditions for valid properties and operators.
     */
    @JvmName("probpbpqojuujdfy")
    public suspend fun condition(`value`: Output<String>) {
        this.condition = value
    }

    /**
     * @param value List of operations to execute when the condition predicate satisfies.
     */
    @JvmName("ivabdkcqvlcffieb")
    public suspend fun operations(`value`: Output<List<StorageTaskOperationArgs>>) {
        this.operations = value
    }

    @JvmName("bgsdcdbcfsdbevti")
    public suspend fun operations(vararg values: Output<StorageTaskOperationArgs>) {
        this.operations = Output.all(values.asList())
    }

    /**
     * @param values List of operations to execute when the condition predicate satisfies.
     */
    @JvmName("kdbpkhftwejryciy")
    public suspend fun operations(values: List<Output<StorageTaskOperationArgs>>) {
        this.operations = Output.all(values)
    }

    /**
     * @param value Condition predicate to evaluate each object. See https://aka.ms/storagetaskconditions for valid properties and operators.
     */
    @JvmName("yfsnhdrmxctmyyre")
    public suspend fun condition(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.condition = mapped
    }

    /**
     * @param value List of operations to execute when the condition predicate satisfies.
     */
    @JvmName("rpkmsyehrmywltbr")
    public suspend fun operations(`value`: List<StorageTaskOperationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operations = mapped
    }

    /**
     * @param argument List of operations to execute when the condition predicate satisfies.
     */
    @JvmName("cnbsicvwulwethme")
    public suspend fun operations(argument: List<suspend StorageTaskOperationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StorageTaskOperationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.operations = mapped
    }

    /**
     * @param argument List of operations to execute when the condition predicate satisfies.
     */
    @JvmName("ucnawxnihrunaxks")
    public suspend fun operations(vararg argument: suspend StorageTaskOperationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            StorageTaskOperationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.operations = mapped
    }

    /**
     * @param argument List of operations to execute when the condition predicate satisfies.
     */
    @JvmName("juwsyoxndwdjmbil")
    public suspend fun operations(argument: suspend StorageTaskOperationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StorageTaskOperationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.operations = mapped
    }

    /**
     * @param values List of operations to execute when the condition predicate satisfies.
     */
    @JvmName("kbkbmqowkaqnajwf")
    public suspend fun operations(vararg values: StorageTaskOperationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operations = mapped
    }

    internal fun build(): IfConditionArgs = IfConditionArgs(
        condition = condition ?: throw PulumiNullFieldException("condition"),
        operations = operations ?: throw PulumiNullFieldException("operations"),
    )
}
