@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storageactions.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Represents Storage Task.
 * @property action The storage task action that is executed
 * @property creationTimeInUtc The creation date and time of the storage task in UTC.
 * @property description Text that describes the purpose of the storage task
 * @property enabled Storage Task is enabled when set to true and disabled when set to false
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property identity The managed service identity of the resource.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState Represents the provisioning state of the storage task.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property taskVersion Storage task version.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetStorageTaskResult(
    public val action: StorageTaskActionResponse,
    public val creationTimeInUtc: String,
    public val description: String,
    public val enabled: Boolean,
    public val id: String,
    public val identity: ManagedServiceIdentityResponse,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val taskVersion: Double,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storageactions.outputs.GetStorageTaskResult): GetStorageTaskResult = GetStorageTaskResult(
            action = javaType.action().let({ args0 ->
                com.pulumi.azurenative.storageactions.kotlin.outputs.StorageTaskActionResponse.Companion.toKotlin(args0)
            }),
            creationTimeInUtc = javaType.creationTimeInUtc(),
            description = javaType.description(),
            enabled = javaType.enabled(),
            id = javaType.id(),
            identity = javaType.identity().let({ args0 ->
                com.pulumi.azurenative.storageactions.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
            }),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.storageactions.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            taskVersion = javaType.taskVersion(),
            type = javaType.type(),
        )
    }
}
