@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storageactions.kotlin.outputs

import kotlin.Suppress

/**
 * The storage task action represents conditional statements and operations to be performed on target objects.
 * @property else The else block of storage task operation
 * @property if The if block of storage task operation
 */
public data class StorageTaskActionResponse(
    public val `else`: ElseConditionResponse? = null,
    public val `if`: IfConditionResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storageactions.outputs.StorageTaskActionResponse): StorageTaskActionResponse = StorageTaskActionResponse(
            `else` = javaType.else_().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storageactions.kotlin.outputs.ElseConditionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            `if` = javaType.if_().let({ args0 ->
                com.pulumi.azurenative.storageactions.kotlin.outputs.IfConditionResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
