@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin

import com.pulumi.azurenative.storagecache.kotlin.outputs.CacheDirectorySettingsResponse
import com.pulumi.azurenative.storagecache.kotlin.outputs.CacheEncryptionSettingsResponse
import com.pulumi.azurenative.storagecache.kotlin.outputs.CacheHealthResponse
import com.pulumi.azurenative.storagecache.kotlin.outputs.CacheIdentityResponse
import com.pulumi.azurenative.storagecache.kotlin.outputs.CacheNetworkSettingsResponse
import com.pulumi.azurenative.storagecache.kotlin.outputs.CacheResponseSku
import com.pulumi.azurenative.storagecache.kotlin.outputs.CacheSecuritySettingsResponse
import com.pulumi.azurenative.storagecache.kotlin.outputs.CacheUpgradeSettingsResponse
import com.pulumi.azurenative.storagecache.kotlin.outputs.CacheUpgradeStatusResponse
import com.pulumi.azurenative.storagecache.kotlin.outputs.PrimingJobResponse
import com.pulumi.azurenative.storagecache.kotlin.outputs.StorageTargetSpaceAllocationResponse
import com.pulumi.azurenative.storagecache.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.storagecache.kotlin.outputs.CacheDirectorySettingsResponse.Companion.toKotlin as cacheDirectorySettingsResponseToKotlin
import com.pulumi.azurenative.storagecache.kotlin.outputs.CacheEncryptionSettingsResponse.Companion.toKotlin as cacheEncryptionSettingsResponseToKotlin
import com.pulumi.azurenative.storagecache.kotlin.outputs.CacheHealthResponse.Companion.toKotlin as cacheHealthResponseToKotlin
import com.pulumi.azurenative.storagecache.kotlin.outputs.CacheIdentityResponse.Companion.toKotlin as cacheIdentityResponseToKotlin
import com.pulumi.azurenative.storagecache.kotlin.outputs.CacheNetworkSettingsResponse.Companion.toKotlin as cacheNetworkSettingsResponseToKotlin
import com.pulumi.azurenative.storagecache.kotlin.outputs.CacheResponseSku.Companion.toKotlin as cacheResponseSkuToKotlin
import com.pulumi.azurenative.storagecache.kotlin.outputs.CacheSecuritySettingsResponse.Companion.toKotlin as cacheSecuritySettingsResponseToKotlin
import com.pulumi.azurenative.storagecache.kotlin.outputs.CacheUpgradeSettingsResponse.Companion.toKotlin as cacheUpgradeSettingsResponseToKotlin
import com.pulumi.azurenative.storagecache.kotlin.outputs.CacheUpgradeStatusResponse.Companion.toKotlin as cacheUpgradeStatusResponseToKotlin
import com.pulumi.azurenative.storagecache.kotlin.outputs.PrimingJobResponse.Companion.toKotlin as primingJobResponseToKotlin
import com.pulumi.azurenative.storagecache.kotlin.outputs.StorageTargetSpaceAllocationResponse.Companion.toKotlin as storageTargetSpaceAllocationResponseToKotlin
import com.pulumi.azurenative.storagecache.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Cache].
 */
@PulumiTagMarker
public class CacheResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CacheArgs = CacheArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CacheArgsBuilder.() -> Unit) {
        val builder = CacheArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Cache {
        val builtJavaResource = com.pulumi.azurenative.storagecache.Cache(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Cache(builtJavaResource)
    }
}

/**
 * A cache instance. Follows Azure Resource Manager standards: https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/resource-api-reference.md
 * Azure REST API version: 2023-05-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * Other available API versions: 2020-10-01, 2021-03-01, 2023-03-01-preview, 2023-11-01-preview, 2024-03-01.
 * ## Example Usage
 * ### Caches_CreateOrUpdate_ldap_only
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cache = new AzureNative.StorageCache.Cache("cache", new()
 *     {
 *         CacheName = "sc1",
 *         CacheSizeGB = 3072,
 *         DirectoryServicesSettings = new AzureNative.StorageCache.Inputs.CacheDirectorySettingsArgs
 *         {
 *             UsernameDownload = new AzureNative.StorageCache.Inputs.CacheUsernameDownloadSettingsArgs
 *             {
 *                 Credentials = new AzureNative.StorageCache.Inputs.CacheUsernameDownloadSettingsCredentialsArgs
 *                 {
 *                     BindDn = "cn=ldapadmin,dc=contosoad,dc=contoso,dc=local",
 *                     BindPassword = "<bindPassword>",
 *                 },
 *                 ExtendedGroups = true,
 *                 LdapBaseDN = "dc=contosoad,dc=contoso,dc=local",
 *                 LdapServer = "192.0.2.12",
 *                 UsernameSource = AzureNative.StorageCache.UsernameSource.LDAP,
 *             },
 *         },
 *         EncryptionSettings = new AzureNative.StorageCache.Inputs.CacheEncryptionSettingsArgs
 *         {
 *             KeyEncryptionKey = new AzureNative.StorageCache.Inputs.KeyVaultKeyReferenceArgs
 *             {
 *                 KeyUrl = "https://keyvault-cmk.vault.azure.net/keys/key2048/test",
 *                 SourceVault = new AzureNative.StorageCache.Inputs.KeyVaultKeyReferenceSourceVaultArgs
 *                 {
 *                     Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scgroup/providers/Microsoft.KeyVault/vaults/keyvault-cmk",
 *                 },
 *             },
 *         },
 *         Location = "westus",
 *         ResourceGroupName = "scgroup",
 *         SecuritySettings = new AzureNative.StorageCache.Inputs.CacheSecuritySettingsArgs
 *         {
 *             AccessPolicies = new[]
 *             {
 *                 new AzureNative.StorageCache.Inputs.NfsAccessPolicyArgs
 *                 {
 *                     AccessRules = new[]
 *                     {
 *                         new AzureNative.StorageCache.Inputs.NfsAccessRuleArgs
 *                         {
 *                             Access = AzureNative.StorageCache.NfsAccessRuleAccess.Rw,
 *                             RootSquash = false,
 *                             Scope = AzureNative.StorageCache.NfsAccessRuleScope.@Default,
 *                             SubmountAccess = true,
 *                             Suid = false,
 *                         },
 *                     },
 *                     Name = "default",
 *                 },
 *             },
 *         },
 *         Sku = new AzureNative.StorageCache.Inputs.CacheSkuArgs
 *         {
 *             Name = "Standard_2G",
 *         },
 *         Subnet = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scgroup/providers/Microsoft.Network/virtualNetworks/scvnet/subnets/sub1",
 *         Tags =
 *         {
 *             { "Dept", "Contoso" },
 *         },
 *         UpgradeSettings = new AzureNative.StorageCache.Inputs.CacheUpgradeSettingsArgs
 *         {
 *             ScheduledTime = "2022-04-26T18:25:43.511Z",
 *             UpgradeScheduleEnabled = true,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagecache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagecache.NewCache(ctx, "cache", &storagecache.CacheArgs{
 * 			CacheName:   pulumi.String("sc1"),
 * 			CacheSizeGB: pulumi.Int(3072),
 * 			DirectoryServicesSettings: &storagecache.CacheDirectorySettingsArgs{
 * 				UsernameDownload: &storagecache.CacheUsernameDownloadSettingsArgs{
 * 					Credentials: &storagecache.CacheUsernameDownloadSettingsCredentialsArgs{
 * 						BindDn:       pulumi.String("cn=ldapadmin,dc=contosoad,dc=contoso,dc=local"),
 * 						BindPassword: pulumi.String("<bindPassword>"),
 * 					},
 * 					ExtendedGroups: pulumi.Bool(true),
 * 					LdapBaseDN:     pulumi.String("dc=contosoad,dc=contoso,dc=local"),
 * 					LdapServer:     pulumi.String("192.0.2.12"),
 * 					UsernameSource: pulumi.String(storagecache.UsernameSourceLDAP),
 * 				},
 * 			},
 * 			EncryptionSettings: &storagecache.CacheEncryptionSettingsArgs{
 * 				KeyEncryptionKey: &storagecache.KeyVaultKeyReferenceArgs{
 * 					KeyUrl: pulumi.String("https://keyvault-cmk.vault.azure.net/keys/key2048/test"),
 * 					SourceVault: &storagecache.KeyVaultKeyReferenceSourceVaultArgs{
 * 						Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scgroup/providers/Microsoft.KeyVault/vaults/keyvault-cmk"),
 * 					},
 * 				},
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("scgroup"),
 * 			SecuritySettings: &storagecache.CacheSecuritySettingsArgs{
 * 				AccessPolicies: storagecache.NfsAccessPolicyArray{
 * 					&storagecache.NfsAccessPolicyArgs{
 * 						AccessRules: storagecache.NfsAccessRuleArray{
 * 							&storagecache.NfsAccessRuleArgs{
 * 								Access:         pulumi.String(storagecache.NfsAccessRuleAccessRw),
 * 								RootSquash:     pulumi.Bool(false),
 * 								Scope:          pulumi.String(storagecache.NfsAccessRuleScopeDefault),
 * 								SubmountAccess: pulumi.Bool(true),
 * 								Suid:           pulumi.Bool(false),
 * 							},
 * 						},
 * 						Name: pulumi.String("default"),
 * 					},
 * 				},
 * 			},
 * 			Sku: &storagecache.CacheSkuArgs{
 * 				Name: pulumi.String("Standard_2G"),
 * 			},
 * 			Subnet: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scgroup/providers/Microsoft.Network/virtualNetworks/scvnet/subnets/sub1"),
 * 			Tags: pulumi.StringMap{
 * 				"Dept": pulumi.String("Contoso"),
 * 			},
 * 			UpgradeSettings: &storagecache.CacheUpgradeSettingsArgs{
 * 				ScheduledTime:          pulumi.String("2022-04-26T18:25:43.511Z"),
 * 				UpgradeScheduleEnabled: pulumi.Bool(true),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagecache.Cache;
 * import com.pulumi.azurenative.storagecache.CacheArgs;
 * import com.pulumi.azurenative.storagecache.inputs.CacheDirectorySettingsArgs;
 * import com.pulumi.azurenative.storagecache.inputs.CacheUsernameDownloadSettingsArgs;
 * import com.pulumi.azurenative.storagecache.inputs.CacheUsernameDownloadSettingsCredentialsArgs;
 * import com.pulumi.azurenative.storagecache.inputs.CacheEncryptionSettingsArgs;
 * import com.pulumi.azurenative.storagecache.inputs.KeyVaultKeyReferenceArgs;
 * import com.pulumi.azurenative.storagecache.inputs.KeyVaultKeyReferenceSourceVaultArgs;
 * import com.pulumi.azurenative.storagecache.inputs.CacheSecuritySettingsArgs;
 * import com.pulumi.azurenative.storagecache.inputs.CacheSkuArgs;
 * import com.pulumi.azurenative.storagecache.inputs.CacheUpgradeSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cache = new Cache("cache", CacheArgs.builder()
 *             .cacheName("sc1")
 *             .cacheSizeGB(3072)
 *             .directoryServicesSettings(CacheDirectorySettingsArgs.builder()
 *                 .usernameDownload(CacheUsernameDownloadSettingsArgs.builder()
 *                     .credentials(CacheUsernameDownloadSettingsCredentialsArgs.builder()
 *                         .bindDn("cn=ldapadmin,dc=contosoad,dc=contoso,dc=local")
 *                         .bindPassword("<bindPassword>")
 *                         .build())
 *                     .extendedGroups(true)
 *                     .ldapBaseDN("dc=contosoad,dc=contoso,dc=local")
 *                     .ldapServer("192.0.2.12")
 *                     .usernameSource("LDAP")
 *                     .build())
 *                 .build())
 *             .encryptionSettings(CacheEncryptionSettingsArgs.builder()
 *                 .keyEncryptionKey(KeyVaultKeyReferenceArgs.builder()
 *                     .keyUrl("https://keyvault-cmk.vault.azure.net/keys/key2048/test")
 *                     .sourceVault(KeyVaultKeyReferenceSourceVaultArgs.builder()
 *                         .id("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scgroup/providers/Microsoft.KeyVault/vaults/keyvault-cmk")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .location("westus")
 *             .resourceGroupName("scgroup")
 *             .securitySettings(CacheSecuritySettingsArgs.builder()
 *                 .accessPolicies(NfsAccessPolicyArgs.builder()
 *                     .accessRules(NfsAccessRuleArgs.builder()
 *                         .access("rw")
 *                         .rootSquash(false)
 *                         .scope("default")
 *                         .submountAccess(true)
 *                         .suid(false)
 *                         .build())
 *                     .name("default")
 *                     .build())
 *                 .build())
 *             .sku(CacheSkuArgs.builder()
 *                 .name("Standard_2G")
 *                 .build())
 *             .subnet("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/scgroup/providers/Microsoft.Network/virtualNetworks/scvnet/subnets/sub1")
 *             .tags(Map.of("Dept", "Contoso"))
 *             .upgradeSettings(CacheUpgradeSettingsArgs.builder()
 *                 .scheduledTime("2022-04-26T18:25:43.511Z")
 *                 .upgradeScheduleEnabled(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagecache:Cache sc1 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.StorageCache/caches/{cacheName}
 * ```
 */
public class Cache internal constructor(
    override val javaResource: com.pulumi.azurenative.storagecache.Cache,
) : KotlinCustomResource(javaResource, CacheMapper) {
    /**
     * The size of this Cache, in GB.
     */
    public val cacheSizeGB: Output<Int>?
        get() = javaResource.cacheSizeGB().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies Directory Services settings of the cache.
     */
    public val directoryServicesSettings: Output<CacheDirectorySettingsResponse>?
        get() = javaResource.directoryServicesSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> cacheDirectorySettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies encryption settings of the cache.
     */
    public val encryptionSettings: Output<CacheEncryptionSettingsResponse>?
        get() = javaResource.encryptionSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> cacheEncryptionSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Health of the cache.
     */
    public val health: Output<CacheHealthResponse>
        get() = javaResource.health().applyValue({ args0 ->
            args0.let({ args0 ->
                cacheHealthResponseToKotlin(args0)
            })
        })

    /**
     * The identity of the cache, if configured.
     */
    public val identity: Output<CacheIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    cacheIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Region name string.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Array of IPv4 addresses that can be used by clients mounting this cache.
     */
    public val mountAddresses: Output<List<String>>
        get() = javaResource.mountAddresses().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Name of cache.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies network settings of the cache.
     */
    public val networkSettings: Output<CacheNetworkSettingsResponse>?
        get() = javaResource.networkSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> cacheNetworkSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies the priming jobs defined in the cache.
     */
    public val primingJobs: Output<List<PrimingJobResponse>>
        get() = javaResource.primingJobs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    primingJobResponseToKotlin(args0)
                })
            })
        })

    /**
     * ARM provisioning state, see https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/Addendum.md#provisioningstate-property
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Specifies security settings of the cache.
     */
    public val securitySettings: Output<CacheSecuritySettingsResponse>?
        get() = javaResource.securitySettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> cacheSecuritySettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * SKU for the cache.
     */
    public val sku: Output<CacheResponseSku>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    cacheResponseSkuToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specifies the space allocation percentage for each storage target in the cache.
     */
    public val spaceAllocation: Output<List<StorageTargetSpaceAllocationResponse>>
        get() = javaResource.spaceAllocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> storageTargetSpaceAllocationResponseToKotlin(args0) })
            })
        })

    /**
     * Subnet used for the cache.
     */
    public val subnet: Output<String>?
        get() = javaResource.subnet().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Type of the cache; Microsoft.StorageCache/Cache
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Upgrade settings of the cache.
     */
    public val upgradeSettings: Output<CacheUpgradeSettingsResponse>?
        get() = javaResource.upgradeSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> cacheUpgradeSettingsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Upgrade status of the cache.
     */
    public val upgradeStatus: Output<CacheUpgradeStatusResponse>
        get() = javaResource.upgradeStatus().applyValue({ args0 ->
            args0.let({ args0 ->
                cacheUpgradeStatusResponseToKotlin(args0)
            })
        })

    /**
     * Availability zones for resources. This field should only contain a single element in the array.
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object CacheMapper : ResourceMapper<Cache> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storagecache.Cache::class == javaResource::class

    override fun map(javaResource: Resource): Cache = Cache(
        javaResource as
            com.pulumi.azurenative.storagecache.Cache,
    )
}

/**
 * @see [Cache].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Cache].
 */
public suspend fun cache(name: String, block: suspend CacheResourceBuilder.() -> Unit): Cache {
    val builder = CacheResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Cache].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cache(name: String): Cache {
    val builder = CacheResourceBuilder()
    builder.name(name)
    return builder.build()
}
