@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin

import com.pulumi.azurenative.storagecache.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.storagecache.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ImportJob].
 */
@PulumiTagMarker
public class ImportJobResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ImportJobArgs = ImportJobArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ImportJobArgsBuilder.() -> Unit) {
        val builder = ImportJobArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ImportJob {
        val builtJavaResource = com.pulumi.azurenative.storagecache.ImportJob(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ImportJob(builtJavaResource)
    }
}

/**
 * An import job instance. Follows Azure Resource Manager standards: https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/resource-api-reference.md
 * Azure REST API version: 2024-03-01.
 * ## Example Usage
 * ### importJobs_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var importJob = new AzureNative.StorageCache.ImportJob("importJob", new()
 *     {
 *         AmlFilesystemName = "fs1",
 *         ConflictResolutionMode = AzureNative.StorageCache.ConflictResolutionMode.OverwriteAlways,
 *         ImportJobName = "job1",
 *         ImportPrefixes = new[]
 *         {
 *             "/",
 *         },
 *         Location = "eastus",
 *         MaximumErrors = 0,
 *         ResourceGroupName = "scgroup",
 *         Tags =
 *         {
 *             { "Dept", "ContosoAds" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagecache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagecache.NewImportJob(ctx, "importJob", &storagecache.ImportJobArgs{
 * 			AmlFilesystemName:      pulumi.String("fs1"),
 * 			ConflictResolutionMode: pulumi.String(storagecache.ConflictResolutionModeOverwriteAlways),
 * 			ImportJobName:          pulumi.String("job1"),
 * 			ImportPrefixes: pulumi.StringArray{
 * 				pulumi.String("/"),
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			MaximumErrors:     pulumi.Int(0),
 * 			ResourceGroupName: pulumi.String("scgroup"),
 * 			Tags: pulumi.StringMap{
 * 				"Dept": pulumi.String("ContosoAds"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagecache.ImportJob;
 * import com.pulumi.azurenative.storagecache.ImportJobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var importJob = new ImportJob("importJob", ImportJobArgs.builder()
 *             .amlFilesystemName("fs1")
 *             .conflictResolutionMode("OverwriteAlways")
 *             .importJobName("job1")
 *             .importPrefixes("/")
 *             .location("eastus")
 *             .maximumErrors(0)
 *             .resourceGroupName("scgroup")
 *             .tags(Map.of("Dept", "ContosoAds"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagecache:ImportJob job1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/importJobs/{importJobName}
 * ```
 */
public class ImportJob internal constructor(
    override val javaResource: com.pulumi.azurenative.storagecache.ImportJob,
) : KotlinCustomResource(javaResource, ImportJobMapper) {
    /**
     * A recent and frequently updated rate of total files, directories, and symlinks imported per second.
     */
    public val blobsImportedPerSecond: Output<Double>
        get() = javaResource.blobsImportedPerSecond().applyValue({ args0 -> args0 })

    /**
     * A recent and frequently updated rate of blobs walked per second.
     */
    public val blobsWalkedPerSecond: Output<Double>
        get() = javaResource.blobsWalkedPerSecond().applyValue({ args0 -> args0 })

    /**
     * How the import job will handle conflicts. For example, if the import job is trying to bring in a directory, but a file is at that path, how it handles it. Fail indicates that the import job should stop immediately and not do anything with the conflict. Skip indicates that it should pass over the conflict. OverwriteIfDirty causes the import job to delete and re-import the file or directory if it is a conflicting type, is dirty, or was not previously imported. OverwriteAlways extends OverwriteIfDirty to include releasing files that had been restored but were not dirty. Please reference https://learn.microsoft.com/en-us/azure/azure-managed-lustre/ for a thorough explanation of these resolution modes.
     */
    public val conflictResolutionMode: Output<String>?
        get() = javaResource.conflictResolutionMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An array of blob paths/prefixes that get imported into the cluster namespace. It has '/' as the default value.
     */
    public val importPrefixes: Output<List<String>>?
        get() = javaResource.importPrefixes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The time of the last completed archive operation
     */
    public val lastCompletionTime: Output<String>
        get() = javaResource.lastCompletionTime().applyValue({ args0 -> args0 })

    /**
     * The time the latest archive operation started
     */
    public val lastStartedTime: Output<String>
        get() = javaResource.lastStartedTime().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Total non-conflict oriented errors the import job will tolerate before exiting with failure. -1 means infinite. 0 means exit immediately and is the default.
     */
    public val maximumErrors: Output<Int>?
        get() = javaResource.maximumErrors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * ARM provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The state of the import job. InProgress indicates the import is still running. Canceled indicates it has been canceled by the user. Completed indicates import finished, successfully importing all discovered blobs into the Lustre namespace. CompletedPartial indicates the import finished but some blobs either were found to be conflicting and could not be imported or other errors were encountered. Failed means the import was unable to complete due to a fatal error.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * The status message of the import job.
     */
    public val statusMessage: Output<String>
        get() = javaResource.statusMessage().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The total blobs that have been imported since import began.
     */
    public val totalBlobsImported: Output<Double>
        get() = javaResource.totalBlobsImported().applyValue({ args0 -> args0 })

    /**
     * The total blob objects walked.
     */
    public val totalBlobsWalked: Output<Double>
        get() = javaResource.totalBlobsWalked().applyValue({ args0 -> args0 })

    /**
     * Number of conflicts in the import job.
     */
    public val totalConflicts: Output<Int>
        get() = javaResource.totalConflicts().applyValue({ args0 -> args0 })

    /**
     * Number of errors in the import job.
     */
    public val totalErrors: Output<Int>
        get() = javaResource.totalErrors().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ImportJobMapper : ResourceMapper<ImportJob> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storagecache.ImportJob::class == javaResource::class

    override fun map(javaResource: Resource): ImportJob = ImportJob(
        javaResource as
            com.pulumi.azurenative.storagecache.ImportJob,
    )
}

/**
 * @see [ImportJob].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ImportJob].
 */
public suspend fun importJob(name: String, block: suspend ImportJobResourceBuilder.() -> Unit): ImportJob {
    val builder = ImportJobResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ImportJob].
 * @param name The _unique_ name of the resulting resource.
 */
public fun importJob(name: String): ImportJob {
    val builder = ImportJobResourceBuilder()
    builder.name(name)
    return builder.build()
}
