@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin

import com.pulumi.azurenative.storagecache.ImportJobArgs.builder
import com.pulumi.azurenative.storagecache.kotlin.enums.ConflictResolutionMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An import job instance. Follows Azure Resource Manager standards: https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/resource-api-reference.md
 * Azure REST API version: 2024-03-01.
 * ## Example Usage
 * ### importJobs_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var importJob = new AzureNative.StorageCache.ImportJob("importJob", new()
 *     {
 *         AmlFilesystemName = "fs1",
 *         ConflictResolutionMode = AzureNative.StorageCache.ConflictResolutionMode.OverwriteAlways,
 *         ImportJobName = "job1",
 *         ImportPrefixes = new[]
 *         {
 *             "/",
 *         },
 *         Location = "eastus",
 *         MaximumErrors = 0,
 *         ResourceGroupName = "scgroup",
 *         Tags =
 *         {
 *             { "Dept", "ContosoAds" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagecache/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagecache.NewImportJob(ctx, "importJob", &storagecache.ImportJobArgs{
 * 			AmlFilesystemName:      pulumi.String("fs1"),
 * 			ConflictResolutionMode: pulumi.String(storagecache.ConflictResolutionModeOverwriteAlways),
 * 			ImportJobName:          pulumi.String("job1"),
 * 			ImportPrefixes: pulumi.StringArray{
 * 				pulumi.String("/"),
 * 			},
 * 			Location:          pulumi.String("eastus"),
 * 			MaximumErrors:     pulumi.Int(0),
 * 			ResourceGroupName: pulumi.String("scgroup"),
 * 			Tags: pulumi.StringMap{
 * 				"Dept": pulumi.String("ContosoAds"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagecache.ImportJob;
 * import com.pulumi.azurenative.storagecache.ImportJobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var importJob = new ImportJob("importJob", ImportJobArgs.builder()
 *             .amlFilesystemName("fs1")
 *             .conflictResolutionMode("OverwriteAlways")
 *             .importJobName("job1")
 *             .importPrefixes("/")
 *             .location("eastus")
 *             .maximumErrors(0)
 *             .resourceGroupName("scgroup")
 *             .tags(Map.of("Dept", "ContosoAds"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagecache:ImportJob job1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageCache/amlFilesystems/{amlFilesystemName}/importJobs/{importJobName}
 * ```
 * @property amlFilesystemName Name for the AML file system. Allows alphanumerics, underscores, and hyphens. Start and end with alphanumeric.
 * @property conflictResolutionMode How the import job will handle conflicts. For example, if the import job is trying to bring in a directory, but a file is at that path, how it handles it. Fail indicates that the import job should stop immediately and not do anything with the conflict. Skip indicates that it should pass over the conflict. OverwriteIfDirty causes the import job to delete and re-import the file or directory if it is a conflicting type, is dirty, or was not previously imported. OverwriteAlways extends OverwriteIfDirty to include releasing files that had been restored but were not dirty. Please reference https://learn.microsoft.com/en-us/azure/azure-managed-lustre/ for a thorough explanation of these resolution modes.
 * @property importJobName Name for the import job. Allows alphanumerics, underscores, and hyphens. Start and end with alphanumeric.
 * @property importPrefixes An array of blob paths/prefixes that get imported into the cluster namespace. It has '/' as the default value.
 * @property location The geo-location where the resource lives
 * @property maximumErrors Total non-conflict oriented errors the import job will tolerate before exiting with failure. -1 means infinite. 0 means exit immediately and is the default.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class ImportJobArgs(
    public val amlFilesystemName: Output<String>? = null,
    public val conflictResolutionMode: Output<Either<String, ConflictResolutionMode>>? = null,
    public val importJobName: Output<String>? = null,
    public val importPrefixes: Output<List<String>>? = null,
    public val location: Output<String>? = null,
    public val maximumErrors: Output<Int>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.ImportJobArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.ImportJobArgs =
        com.pulumi.azurenative.storagecache.ImportJobArgs.builder()
            .amlFilesystemName(amlFilesystemName?.applyValue({ args0 -> args0 }))
            .conflictResolutionMode(
                conflictResolutionMode?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .importJobName(importJobName?.applyValue({ args0 -> args0 }))
            .importPrefixes(importPrefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .maximumErrors(maximumErrors?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ImportJobArgs].
 */
@PulumiTagMarker
public class ImportJobArgsBuilder internal constructor() {
    private var amlFilesystemName: Output<String>? = null

    private var conflictResolutionMode: Output<Either<String, ConflictResolutionMode>>? = null

    private var importJobName: Output<String>? = null

    private var importPrefixes: Output<List<String>>? = null

    private var location: Output<String>? = null

    private var maximumErrors: Output<Int>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name for the AML file system. Allows alphanumerics, underscores, and hyphens. Start and end with alphanumeric.
     */
    @JvmName("giwyqfbycwdgwjqe")
    public suspend fun amlFilesystemName(`value`: Output<String>) {
        this.amlFilesystemName = value
    }

    /**
     * @param value How the import job will handle conflicts. For example, if the import job is trying to bring in a directory, but a file is at that path, how it handles it. Fail indicates that the import job should stop immediately and not do anything with the conflict. Skip indicates that it should pass over the conflict. OverwriteIfDirty causes the import job to delete and re-import the file or directory if it is a conflicting type, is dirty, or was not previously imported. OverwriteAlways extends OverwriteIfDirty to include releasing files that had been restored but were not dirty. Please reference https://learn.microsoft.com/en-us/azure/azure-managed-lustre/ for a thorough explanation of these resolution modes.
     */
    @JvmName("ovdpvikyvjtkxatc")
    public suspend fun conflictResolutionMode(`value`: Output<Either<String, ConflictResolutionMode>>) {
        this.conflictResolutionMode = value
    }

    /**
     * @param value Name for the import job. Allows alphanumerics, underscores, and hyphens. Start and end with alphanumeric.
     */
    @JvmName("jhntuxtvjsltojhh")
    public suspend fun importJobName(`value`: Output<String>) {
        this.importJobName = value
    }

    /**
     * @param value An array of blob paths/prefixes that get imported into the cluster namespace. It has '/' as the default value.
     */
    @JvmName("ceorbghjubklvldd")
    public suspend fun importPrefixes(`value`: Output<List<String>>) {
        this.importPrefixes = value
    }

    @JvmName("tllnuvbwixigfejo")
    public suspend fun importPrefixes(vararg values: Output<String>) {
        this.importPrefixes = Output.all(values.asList())
    }

    /**
     * @param values An array of blob paths/prefixes that get imported into the cluster namespace. It has '/' as the default value.
     */
    @JvmName("jqvsiscewqvygbuv")
    public suspend fun importPrefixes(values: List<Output<String>>) {
        this.importPrefixes = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("nlvyrutaylitotbv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Total non-conflict oriented errors the import job will tolerate before exiting with failure. -1 means infinite. 0 means exit immediately and is the default.
     */
    @JvmName("mvxhxxscmguiqutl")
    public suspend fun maximumErrors(`value`: Output<Int>) {
        this.maximumErrors = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lowmfhlhvtwrwxot")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("nujneulrpqbmvbbp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name for the AML file system. Allows alphanumerics, underscores, and hyphens. Start and end with alphanumeric.
     */
    @JvmName("ngvnragcorqnefsx")
    public suspend fun amlFilesystemName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amlFilesystemName = mapped
    }

    /**
     * @param value How the import job will handle conflicts. For example, if the import job is trying to bring in a directory, but a file is at that path, how it handles it. Fail indicates that the import job should stop immediately and not do anything with the conflict. Skip indicates that it should pass over the conflict. OverwriteIfDirty causes the import job to delete and re-import the file or directory if it is a conflicting type, is dirty, or was not previously imported. OverwriteAlways extends OverwriteIfDirty to include releasing files that had been restored but were not dirty. Please reference https://learn.microsoft.com/en-us/azure/azure-managed-lustre/ for a thorough explanation of these resolution modes.
     */
    @JvmName("ewudmpaeykinqofv")
    public suspend fun conflictResolutionMode(`value`: Either<String, ConflictResolutionMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.conflictResolutionMode = mapped
    }

    /**
     * @param value How the import job will handle conflicts. For example, if the import job is trying to bring in a directory, but a file is at that path, how it handles it. Fail indicates that the import job should stop immediately and not do anything with the conflict. Skip indicates that it should pass over the conflict. OverwriteIfDirty causes the import job to delete and re-import the file or directory if it is a conflicting type, is dirty, or was not previously imported. OverwriteAlways extends OverwriteIfDirty to include releasing files that had been restored but were not dirty. Please reference https://learn.microsoft.com/en-us/azure/azure-managed-lustre/ for a thorough explanation of these resolution modes.
     */
    @JvmName("rgknhwrvqokqpnbk")
    public fun conflictResolutionMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConflictResolutionMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conflictResolutionMode = mapped
    }

    /**
     * @param value How the import job will handle conflicts. For example, if the import job is trying to bring in a directory, but a file is at that path, how it handles it. Fail indicates that the import job should stop immediately and not do anything with the conflict. Skip indicates that it should pass over the conflict. OverwriteIfDirty causes the import job to delete and re-import the file or directory if it is a conflicting type, is dirty, or was not previously imported. OverwriteAlways extends OverwriteIfDirty to include releasing files that had been restored but were not dirty. Please reference https://learn.microsoft.com/en-us/azure/azure-managed-lustre/ for a thorough explanation of these resolution modes.
     */
    @JvmName("wdsqjdksivheqlke")
    public fun conflictResolutionMode(`value`: ConflictResolutionMode) {
        val toBeMapped = Either.ofRight<String, ConflictResolutionMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conflictResolutionMode = mapped
    }

    /**
     * @param value Name for the import job. Allows alphanumerics, underscores, and hyphens. Start and end with alphanumeric.
     */
    @JvmName("cotrmxvfoxvvwhro")
    public suspend fun importJobName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importJobName = mapped
    }

    /**
     * @param value An array of blob paths/prefixes that get imported into the cluster namespace. It has '/' as the default value.
     */
    @JvmName("qotkpxcytwdsggsw")
    public suspend fun importPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importPrefixes = mapped
    }

    /**
     * @param values An array of blob paths/prefixes that get imported into the cluster namespace. It has '/' as the default value.
     */
    @JvmName("acodnifeauduykuh")
    public suspend fun importPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.importPrefixes = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("kovhvkllhsqnngtw")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Total non-conflict oriented errors the import job will tolerate before exiting with failure. -1 means infinite. 0 means exit immediately and is the default.
     */
    @JvmName("stbsagmlsmcbnywm")
    public suspend fun maximumErrors(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumErrors = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qaciixgmqrrbeles")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bljecqkthjhhjejt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("jxcpxasdjcljsctb")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ImportJobArgs = ImportJobArgs(
        amlFilesystemName = amlFilesystemName,
        conflictResolutionMode = conflictResolutionMode,
        importJobName = importJobName,
        importPrefixes = importPrefixes,
        location = location,
        maximumErrors = maximumErrors,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
