@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * How the import job will handle conflicts. For example, if the import job is trying to bring in a directory, but a file is at that path, how it handles it. Fail indicates that the import job should stop immediately and not do anything with the conflict. Skip indicates that it should pass over the conflict. OverwriteIfDirty causes the import job to delete and re-import the file or directory if it is a conflicting type, is dirty, or was not previously imported. OverwriteAlways extends OverwriteIfDirty to include releasing files that had been restored but were not dirty. Please reference https://learn.microsoft.com/en-us/azure/azure-managed-lustre/ for a thorough explanation of these resolution modes.
 */
public enum class ConflictResolutionMode(
    public val javaValue: com.pulumi.azurenative.storagecache.enums.ConflictResolutionMode,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.enums.ConflictResolutionMode> {
    Fail(com.pulumi.azurenative.storagecache.enums.ConflictResolutionMode.Fail),
    Skip(com.pulumi.azurenative.storagecache.enums.ConflictResolutionMode.Skip),
    OverwriteIfDirty(com.pulumi.azurenative.storagecache.enums.ConflictResolutionMode.OverwriteIfDirty),
    OverwriteAlways(com.pulumi.azurenative.storagecache.enums.ConflictResolutionMode.OverwriteAlways),
    ;

    override fun toJava(): com.pulumi.azurenative.storagecache.enums.ConflictResolutionMode =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagecache.enums.ConflictResolutionMode): ConflictResolutionMode = ConflictResolutionMode.values().first { it.javaValue == javaType }
    }
}
