@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.AmlFilesystemHsmSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * AML file system HSM settings.
 * @property container Resource ID of storage container used for hydrating the namespace and archiving from the namespace. The resource provider must have permission to create SAS tokens on the storage account.
 * @property importPrefix Only blobs in the non-logging container that start with this path/prefix get hydrated into the cluster namespace.
 * @property loggingContainer Resource ID of storage container used for logging events and errors.  Must be a separate container in the same storage account as the hydration and archive container. The resource provider must have permission to create SAS tokens on the storage account.
 */
public data class AmlFilesystemHsmSettingsArgs(
    public val container: Output<String>,
    public val importPrefix: Output<String>? = null,
    public val loggingContainer: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.AmlFilesystemHsmSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.inputs.AmlFilesystemHsmSettingsArgs =
        com.pulumi.azurenative.storagecache.inputs.AmlFilesystemHsmSettingsArgs.builder()
            .container(container.applyValue({ args0 -> args0 }))
            .importPrefix(importPrefix?.applyValue({ args0 -> args0 }))
            .loggingContainer(loggingContainer.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AmlFilesystemHsmSettingsArgs].
 */
@PulumiTagMarker
public class AmlFilesystemHsmSettingsArgsBuilder internal constructor() {
    private var container: Output<String>? = null

    private var importPrefix: Output<String>? = null

    private var loggingContainer: Output<String>? = null

    /**
     * @param value Resource ID of storage container used for hydrating the namespace and archiving from the namespace. The resource provider must have permission to create SAS tokens on the storage account.
     */
    @JvmName("btlojwxhoibwmnrj")
    public suspend fun container(`value`: Output<String>) {
        this.container = value
    }

    /**
     * @param value Only blobs in the non-logging container that start with this path/prefix get hydrated into the cluster namespace.
     */
    @JvmName("lbbillmlchbpsqsr")
    public suspend fun importPrefix(`value`: Output<String>) {
        this.importPrefix = value
    }

    /**
     * @param value Resource ID of storage container used for logging events and errors.  Must be a separate container in the same storage account as the hydration and archive container. The resource provider must have permission to create SAS tokens on the storage account.
     */
    @JvmName("camiuwloccqrowcg")
    public suspend fun loggingContainer(`value`: Output<String>) {
        this.loggingContainer = value
    }

    /**
     * @param value Resource ID of storage container used for hydrating the namespace and archiving from the namespace. The resource provider must have permission to create SAS tokens on the storage account.
     */
    @JvmName("awrfnrovtqknhhop")
    public suspend fun container(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.container = mapped
    }

    /**
     * @param value Only blobs in the non-logging container that start with this path/prefix get hydrated into the cluster namespace.
     */
    @JvmName("subdchmxopwetfis")
    public suspend fun importPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importPrefix = mapped
    }

    /**
     * @param value Resource ID of storage container used for logging events and errors.  Must be a separate container in the same storage account as the hydration and archive container. The resource provider must have permission to create SAS tokens on the storage account.
     */
    @JvmName("uvxoologufboqqrf")
    public suspend fun loggingContainer(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.loggingContainer = mapped
    }

    internal fun build(): AmlFilesystemHsmSettingsArgs = AmlFilesystemHsmSettingsArgs(
        container = container ?: throw PulumiNullFieldException("container"),
        importPrefix = importPrefix,
        loggingContainer = loggingContainer ?: throw PulumiNullFieldException("loggingContainer"),
    )
}
