@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.AmlFilesystemMaintenanceWindowArgs.builder
import com.pulumi.azurenative.storagecache.kotlin.enums.MaintenanceDayOfWeekType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Start time of a 30-minute weekly maintenance window.
 * @property dayOfWeek Day of the week on which the maintenance window will occur.
 * @property timeOfDayUTC The time of day (in UTC) to start the maintenance window.
 */
public data class AmlFilesystemMaintenanceWindowArgs(
    public val dayOfWeek: Output<MaintenanceDayOfWeekType>? = null,
    public val timeOfDayUTC: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.AmlFilesystemMaintenanceWindowArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.inputs.AmlFilesystemMaintenanceWindowArgs =
        com.pulumi.azurenative.storagecache.inputs.AmlFilesystemMaintenanceWindowArgs.builder()
            .dayOfWeek(dayOfWeek?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .timeOfDayUTC(timeOfDayUTC?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AmlFilesystemMaintenanceWindowArgs].
 */
@PulumiTagMarker
public class AmlFilesystemMaintenanceWindowArgsBuilder internal constructor() {
    private var dayOfWeek: Output<MaintenanceDayOfWeekType>? = null

    private var timeOfDayUTC: Output<String>? = null

    /**
     * @param value Day of the week on which the maintenance window will occur.
     */
    @JvmName("snjuswsbepoehjpr")
    public suspend fun dayOfWeek(`value`: Output<MaintenanceDayOfWeekType>) {
        this.dayOfWeek = value
    }

    /**
     * @param value The time of day (in UTC) to start the maintenance window.
     */
    @JvmName("hkgypwpuljcdlqkj")
    public suspend fun timeOfDayUTC(`value`: Output<String>) {
        this.timeOfDayUTC = value
    }

    /**
     * @param value Day of the week on which the maintenance window will occur.
     */
    @JvmName("aapkxcarruvqbtoy")
    public suspend fun dayOfWeek(`value`: MaintenanceDayOfWeekType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dayOfWeek = mapped
    }

    /**
     * @param value The time of day (in UTC) to start the maintenance window.
     */
    @JvmName("vhjdsrfejbrgwujp")
    public suspend fun timeOfDayUTC(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeOfDayUTC = mapped
    }

    internal fun build(): AmlFilesystemMaintenanceWindowArgs = AmlFilesystemMaintenanceWindowArgs(
        dayOfWeek = dayOfWeek,
        timeOfDayUTC = timeOfDayUTC,
    )
}
