@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.CacheActiveDirectorySettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Active Directory settings used to join a cache to a domain.
 * @property cacheNetBiosName The NetBIOS name to assign to the HPC Cache when it joins the Active Directory domain as a server. Length must 1-15 characters from the class [-0-9a-zA-Z].
 * @property credentials Active Directory admin credentials used to join the HPC Cache to a domain.
 * @property domainName The fully qualified domain name of the Active Directory domain controller.
 * @property domainNetBiosName The Active Directory domain's NetBIOS name.
 * @property primaryDnsIpAddress Primary DNS IP address used to resolve the Active Directory domain controller's fully qualified domain name.
 * @property secondaryDnsIpAddress Secondary DNS IP address used to resolve the Active Directory domain controller's fully qualified domain name.
 */
public data class CacheActiveDirectorySettingsArgs(
    public val cacheNetBiosName: Output<String>,
    public val credentials: Output<CacheActiveDirectorySettingsCredentialsArgs>? = null,
    public val domainName: Output<String>,
    public val domainNetBiosName: Output<String>,
    public val primaryDnsIpAddress: Output<String>,
    public val secondaryDnsIpAddress: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.CacheActiveDirectorySettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.inputs.CacheActiveDirectorySettingsArgs = com.pulumi.azurenative.storagecache.inputs.CacheActiveDirectorySettingsArgs.builder()
        .cacheNetBiosName(cacheNetBiosName.applyValue({ args0 -> args0 }))
        .credentials(credentials?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .domainName(domainName.applyValue({ args0 -> args0 }))
        .domainNetBiosName(domainNetBiosName.applyValue({ args0 -> args0 }))
        .primaryDnsIpAddress(primaryDnsIpAddress.applyValue({ args0 -> args0 }))
        .secondaryDnsIpAddress(secondaryDnsIpAddress?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CacheActiveDirectorySettingsArgs].
 */
@PulumiTagMarker
public class CacheActiveDirectorySettingsArgsBuilder internal constructor() {
    private var cacheNetBiosName: Output<String>? = null

    private var credentials: Output<CacheActiveDirectorySettingsCredentialsArgs>? = null

    private var domainName: Output<String>? = null

    private var domainNetBiosName: Output<String>? = null

    private var primaryDnsIpAddress: Output<String>? = null

    private var secondaryDnsIpAddress: Output<String>? = null

    /**
     * @param value The NetBIOS name to assign to the HPC Cache when it joins the Active Directory domain as a server. Length must 1-15 characters from the class [-0-9a-zA-Z].
     */
    @JvmName("nipuxyqbifplmqfj")
    public suspend fun cacheNetBiosName(`value`: Output<String>) {
        this.cacheNetBiosName = value
    }

    /**
     * @param value Active Directory admin credentials used to join the HPC Cache to a domain.
     */
    @JvmName("nwcwdscagikhgcns")
    public suspend fun credentials(`value`: Output<CacheActiveDirectorySettingsCredentialsArgs>) {
        this.credentials = value
    }

    /**
     * @param value The fully qualified domain name of the Active Directory domain controller.
     */
    @JvmName("ybkiutitmfwcmtix")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The Active Directory domain's NetBIOS name.
     */
    @JvmName("jugwbvttgdqwbgxp")
    public suspend fun domainNetBiosName(`value`: Output<String>) {
        this.domainNetBiosName = value
    }

    /**
     * @param value Primary DNS IP address used to resolve the Active Directory domain controller's fully qualified domain name.
     */
    @JvmName("qkxjxuynapkkxdch")
    public suspend fun primaryDnsIpAddress(`value`: Output<String>) {
        this.primaryDnsIpAddress = value
    }

    /**
     * @param value Secondary DNS IP address used to resolve the Active Directory domain controller's fully qualified domain name.
     */
    @JvmName("klaeudxmldtfaiyy")
    public suspend fun secondaryDnsIpAddress(`value`: Output<String>) {
        this.secondaryDnsIpAddress = value
    }

    /**
     * @param value The NetBIOS name to assign to the HPC Cache when it joins the Active Directory domain as a server. Length must 1-15 characters from the class [-0-9a-zA-Z].
     */
    @JvmName("dkjfjeblorbvynhn")
    public suspend fun cacheNetBiosName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cacheNetBiosName = mapped
    }

    /**
     * @param value Active Directory admin credentials used to join the HPC Cache to a domain.
     */
    @JvmName("fgyjaoqfbcegjqgx")
    public suspend fun credentials(`value`: CacheActiveDirectorySettingsCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument Active Directory admin credentials used to join the HPC Cache to a domain.
     */
    @JvmName("mcrsfeqfjqxtuxyr")
    public suspend fun credentials(argument: suspend CacheActiveDirectorySettingsCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = CacheActiveDirectorySettingsCredentialsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value The fully qualified domain name of the Active Directory domain controller.
     */
    @JvmName("nxrfsrkvdaxovouk")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The Active Directory domain's NetBIOS name.
     */
    @JvmName("sjbekqwjoidbbcvn")
    public suspend fun domainNetBiosName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainNetBiosName = mapped
    }

    /**
     * @param value Primary DNS IP address used to resolve the Active Directory domain controller's fully qualified domain name.
     */
    @JvmName("xtvukcxwaqlfrngk")
    public suspend fun primaryDnsIpAddress(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.primaryDnsIpAddress = mapped
    }

    /**
     * @param value Secondary DNS IP address used to resolve the Active Directory domain controller's fully qualified domain name.
     */
    @JvmName("qyboqiimlwypbxyb")
    public suspend fun secondaryDnsIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryDnsIpAddress = mapped
    }

    internal fun build(): CacheActiveDirectorySettingsArgs = CacheActiveDirectorySettingsArgs(
        cacheNetBiosName = cacheNetBiosName ?: throw PulumiNullFieldException("cacheNetBiosName"),
        credentials = credentials,
        domainName = domainName ?: throw PulumiNullFieldException("domainName"),
        domainNetBiosName = domainNetBiosName ?: throw PulumiNullFieldException("domainNetBiosName"),
        primaryDnsIpAddress = primaryDnsIpAddress ?: throw PulumiNullFieldException("primaryDnsIpAddress"),
        secondaryDnsIpAddress = secondaryDnsIpAddress,
    )
}
