@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.CacheEncryptionSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Cache encryption settings.
 * @property keyEncryptionKey Specifies the location of the key encryption key in key vault.
 * @property rotationToLatestKeyVersionEnabled Specifies whether the service will automatically rotate to the newest version of the key in the key vault.
 */
public data class CacheEncryptionSettingsArgs(
    public val keyEncryptionKey: Output<KeyVaultKeyReferenceArgs>? = null,
    public val rotationToLatestKeyVersionEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.CacheEncryptionSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.inputs.CacheEncryptionSettingsArgs =
        com.pulumi.azurenative.storagecache.inputs.CacheEncryptionSettingsArgs.builder()
            .keyEncryptionKey(keyEncryptionKey?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rotationToLatestKeyVersionEnabled(
                rotationToLatestKeyVersionEnabled?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [CacheEncryptionSettingsArgs].
 */
@PulumiTagMarker
public class CacheEncryptionSettingsArgsBuilder internal constructor() {
    private var keyEncryptionKey: Output<KeyVaultKeyReferenceArgs>? = null

    private var rotationToLatestKeyVersionEnabled: Output<Boolean>? = null

    /**
     * @param value Specifies the location of the key encryption key in key vault.
     */
    @JvmName("kmthjvqpbcbotqmu")
    public suspend fun keyEncryptionKey(`value`: Output<KeyVaultKeyReferenceArgs>) {
        this.keyEncryptionKey = value
    }

    /**
     * @param value Specifies whether the service will automatically rotate to the newest version of the key in the key vault.
     */
    @JvmName("xrbenkhlutaiiapy")
    public suspend fun rotationToLatestKeyVersionEnabled(`value`: Output<Boolean>) {
        this.rotationToLatestKeyVersionEnabled = value
    }

    /**
     * @param value Specifies the location of the key encryption key in key vault.
     */
    @JvmName("ddjgblurlhmgphji")
    public suspend fun keyEncryptionKey(`value`: KeyVaultKeyReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyEncryptionKey = mapped
    }

    /**
     * @param argument Specifies the location of the key encryption key in key vault.
     */
    @JvmName("gnedipqkekippmow")
    public suspend fun keyEncryptionKey(argument: suspend KeyVaultKeyReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultKeyReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyEncryptionKey = mapped
    }

    /**
     * @param value Specifies whether the service will automatically rotate to the newest version of the key in the key vault.
     */
    @JvmName("pgxrlwkervmjmqrq")
    public suspend fun rotationToLatestKeyVersionEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rotationToLatestKeyVersionEnabled = mapped
    }

    internal fun build(): CacheEncryptionSettingsArgs = CacheEncryptionSettingsArgs(
        keyEncryptionKey = keyEncryptionKey,
        rotationToLatestKeyVersionEnabled = rotationToLatestKeyVersionEnabled,
    )
}
