@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.CacheIdentityArgs.builder
import com.pulumi.azurenative.storagecache.kotlin.enums.CacheIdentityType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Cache identity properties.
 * @property type The type of identity used for the cache
 * @property userAssignedIdentities A dictionary where each key is a user assigned identity resource ID, and each key's value is an empty dictionary.
 */
public data class CacheIdentityArgs(
    public val type: Output<CacheIdentityType>? = null,
    public val userAssignedIdentities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.CacheIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.inputs.CacheIdentityArgs =
        com.pulumi.azurenative.storagecache.inputs.CacheIdentityArgs.builder()
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [CacheIdentityArgs].
 */
@PulumiTagMarker
public class CacheIdentityArgsBuilder internal constructor() {
    private var type: Output<CacheIdentityType>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value The type of identity used for the cache
     */
    @JvmName("mspsgabhqjqvfdgx")
    public suspend fun type(`value`: Output<CacheIdentityType>) {
        this.type = value
    }

    /**
     * @param value A dictionary where each key is a user assigned identity resource ID, and each key's value is an empty dictionary.
     */
    @JvmName("hwryqrusxtqosefi")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("qdapcifxrdtiydlc")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values A dictionary where each key is a user assigned identity resource ID, and each key's value is an empty dictionary.
     */
    @JvmName("mvmvxfxalsxaiqdh")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value The type of identity used for the cache
     */
    @JvmName("xyiprfhyvfhswgwm")
    public suspend fun type(`value`: CacheIdentityType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value A dictionary where each key is a user assigned identity resource ID, and each key's value is an empty dictionary.
     */
    @JvmName("sqgegbndkxuntdsg")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values A dictionary where each key is a user assigned identity resource ID, and each key's value is an empty dictionary.
     */
    @JvmName("cpwibwpmkiywocnx")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): CacheIdentityArgs = CacheIdentityArgs(
        type = type,
        userAssignedIdentities = userAssignedIdentities,
    )
}
