@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.GetImportJobPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property amlFilesystemName Name for the AML file system. Allows alphanumerics, underscores, and hyphens. Start and end with alphanumeric.
 * @property importJobName Name for the import job. Allows alphanumerics, underscores, and hyphens. Start and end with alphanumeric.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetImportJobPlainArgs(
    public val amlFilesystemName: String,
    public val importJobName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.GetImportJobPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.inputs.GetImportJobPlainArgs =
        com.pulumi.azurenative.storagecache.inputs.GetImportJobPlainArgs.builder()
            .amlFilesystemName(amlFilesystemName.let({ args0 -> args0 }))
            .importJobName(importJobName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetImportJobPlainArgs].
 */
@PulumiTagMarker
public class GetImportJobPlainArgsBuilder internal constructor() {
    private var amlFilesystemName: String? = null

    private var importJobName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name for the AML file system. Allows alphanumerics, underscores, and hyphens. Start and end with alphanumeric.
     */
    @JvmName("sxipnsamxhtbpmhy")
    public suspend fun amlFilesystemName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.amlFilesystemName = mapped
    }

    /**
     * @param value Name for the import job. Allows alphanumerics, underscores, and hyphens. Start and end with alphanumeric.
     */
    @JvmName("dluakysfsjxqijkn")
    public suspend fun importJobName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.importJobName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eewounfmspttgfap")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetImportJobPlainArgs = GetImportJobPlainArgs(
        amlFilesystemName = amlFilesystemName ?: throw PulumiNullFieldException("amlFilesystemName"),
        importJobName = importJobName ?: throw PulumiNullFieldException("importJobName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
