@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.GetStorageTargetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cacheName Name of cache. Length of name must not be greater than 80 and chars must be from the [-0-9a-zA-Z_] char class.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageTargetName Name of Storage Target.
 */
public data class GetStorageTargetPlainArgs(
    public val cacheName: String,
    public val resourceGroupName: String,
    public val storageTargetName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.GetStorageTargetPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.inputs.GetStorageTargetPlainArgs =
        com.pulumi.azurenative.storagecache.inputs.GetStorageTargetPlainArgs.builder()
            .cacheName(cacheName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .storageTargetName(storageTargetName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStorageTargetPlainArgs].
 */
@PulumiTagMarker
public class GetStorageTargetPlainArgsBuilder internal constructor() {
    private var cacheName: String? = null

    private var resourceGroupName: String? = null

    private var storageTargetName: String? = null

    /**
     * @param value Name of cache. Length of name must not be greater than 80 and chars must be from the [-0-9a-zA-Z_] char class.
     */
    @JvmName("odbchqgyypchccgw")
    public suspend fun cacheName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.cacheName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gqvorcmkvbypveys")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of Storage Target.
     */
    @JvmName("xeajjborocdafvuq")
    public suspend fun storageTargetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageTargetName = mapped
    }

    internal fun build(): GetStorageTargetPlainArgs = GetStorageTargetPlainArgs(
        cacheName = cacheName ?: throw PulumiNullFieldException("cacheName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        storageTargetName = storageTargetName ?: throw PulumiNullFieldException("storageTargetName"),
    )
}
