@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.KeyVaultKeyReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes a reference to key vault key.
 * @property keyUrl The URL referencing a key encryption key in key vault.
 * @property sourceVault Describes a resource Id to source key vault.
 */
public data class KeyVaultKeyReferenceArgs(
    public val keyUrl: Output<String>,
    public val sourceVault: Output<KeyVaultKeyReferenceSourceVaultArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.KeyVaultKeyReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.inputs.KeyVaultKeyReferenceArgs =
        com.pulumi.azurenative.storagecache.inputs.KeyVaultKeyReferenceArgs.builder()
            .keyUrl(keyUrl.applyValue({ args0 -> args0 }))
            .sourceVault(sourceVault.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [KeyVaultKeyReferenceArgs].
 */
@PulumiTagMarker
public class KeyVaultKeyReferenceArgsBuilder internal constructor() {
    private var keyUrl: Output<String>? = null

    private var sourceVault: Output<KeyVaultKeyReferenceSourceVaultArgs>? = null

    /**
     * @param value The URL referencing a key encryption key in key vault.
     */
    @JvmName("pjemutbvvpntdkcb")
    public suspend fun keyUrl(`value`: Output<String>) {
        this.keyUrl = value
    }

    /**
     * @param value Describes a resource Id to source key vault.
     */
    @JvmName("bkicdktvmwwigido")
    public suspend fun sourceVault(`value`: Output<KeyVaultKeyReferenceSourceVaultArgs>) {
        this.sourceVault = value
    }

    /**
     * @param value The URL referencing a key encryption key in key vault.
     */
    @JvmName("momkwgaaxwcvjinw")
    public suspend fun keyUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyUrl = mapped
    }

    /**
     * @param value Describes a resource Id to source key vault.
     */
    @JvmName("srrxhnhoofkifnco")
    public suspend fun sourceVault(`value`: KeyVaultKeyReferenceSourceVaultArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceVault = mapped
    }

    /**
     * @param argument Describes a resource Id to source key vault.
     */
    @JvmName("pfygqggufjhficbs")
    public suspend fun sourceVault(argument: suspend KeyVaultKeyReferenceSourceVaultArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultKeyReferenceSourceVaultArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceVault = mapped
    }

    internal fun build(): KeyVaultKeyReferenceArgs = KeyVaultKeyReferenceArgs(
        keyUrl = keyUrl ?: throw PulumiNullFieldException("keyUrl"),
        sourceVault = sourceVault ?: throw PulumiNullFieldException("sourceVault"),
    )
}
