@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.inputs

import com.pulumi.azurenative.storagecache.inputs.KeyVaultKeyReferenceSourceVaultArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a resource Id to source key vault.
 * @property id Resource Id.
 */
public data class KeyVaultKeyReferenceSourceVaultArgs(
    public val id: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.storagecache.inputs.KeyVaultKeyReferenceSourceVaultArgs> {
    override fun toJava(): com.pulumi.azurenative.storagecache.inputs.KeyVaultKeyReferenceSourceVaultArgs =
        com.pulumi.azurenative.storagecache.inputs.KeyVaultKeyReferenceSourceVaultArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultKeyReferenceSourceVaultArgs].
 */
@PulumiTagMarker
public class KeyVaultKeyReferenceSourceVaultArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource Id.
     */
    @JvmName("hqwpstdhqidqiovx")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource Id.
     */
    @JvmName("yacrxmonhmhygjif")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): KeyVaultKeyReferenceSourceVaultArgs = KeyVaultKeyReferenceSourceVaultArgs(
        id = id,
    )
}
