@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * AML file system client information
 * @property containerStorageInterface Container Storage Interface information for the AML file system.
 * @property lustreVersion The version of Lustre running in the AML file system
 * @property mgsAddress The IPv4 address used by clients to mount the AML file system's Lustre Management Service (MGS).
 * @property mountCommand Recommended command to mount the AML file system
 */
public data class AmlFilesystemClientInfoResponse(
    public val containerStorageInterface: AmlFilesystemContainerStorageInterfaceResponse,
    public val lustreVersion: String,
    public val mgsAddress: String,
    public val mountCommand: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.AmlFilesystemClientInfoResponse): AmlFilesystemClientInfoResponse = AmlFilesystemClientInfoResponse(
            containerStorageInterface = javaType.containerStorageInterface().let({ args0 ->
                com.pulumi.azurenative.storagecache.kotlin.outputs.AmlFilesystemContainerStorageInterfaceResponse.Companion.toKotlin(args0)
            }),
            lustreVersion = javaType.lustreVersion(),
            mgsAddress = javaType.mgsAddress(),
            mountCommand = javaType.mountCommand(),
        )
    }
}
