@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.Suppress

/**
 * AML file system encryption settings.
 * @property keyEncryptionKey Specifies the location of the encryption key in Key Vault.
 */
public data class AmlFilesystemEncryptionSettingsResponse(
    public val keyEncryptionKey: KeyVaultKeyReferenceResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.AmlFilesystemEncryptionSettingsResponse): AmlFilesystemEncryptionSettingsResponse = AmlFilesystemEncryptionSettingsResponse(
            keyEncryptionKey = javaType.keyEncryptionKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagecache.kotlin.outputs.KeyVaultKeyReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
