@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An indication of AML file system health. Gives more information about health than just that related to provisioning.
 * @property state List of AML file system health states.
 * @property statusCode Server-defined error code for the AML file system health
 * @property statusDescription Describes the health state.
 */
public data class AmlFilesystemHealthResponse(
    public val state: String? = null,
    public val statusCode: String? = null,
    public val statusDescription: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.AmlFilesystemHealthResponse): AmlFilesystemHealthResponse = AmlFilesystemHealthResponse(
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            statusCode = javaType.statusCode().map({ args0 -> args0 }).orElse(null),
            statusDescription = javaType.statusDescription().map({ args0 -> args0 }).orElse(null),
        )
    }
}
