@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Hydration and archive settings and status
 * @property archiveStatus Archive status
 * @property settings Specifies HSM settings of the AML file system.
 */
public data class AmlFilesystemResponseHsm(
    public val archiveStatus: List<AmlFilesystemArchiveResponse>,
    public val settings: AmlFilesystemHsmSettingsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.AmlFilesystemResponseHsm): AmlFilesystemResponseHsm = AmlFilesystemResponseHsm(
            archiveStatus = javaType.archiveStatus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagecache.kotlin.outputs.AmlFilesystemArchiveResponse.Companion.toKotlin(args0)
                })
            }),
            settings = javaType.settings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagecache.kotlin.outputs.AmlFilesystemHsmSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
