@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Start time of a 30-minute weekly maintenance window.
 * @property dayOfWeek Day of the week on which the maintenance window will occur.
 * @property timeOfDayUTC The time of day (in UTC) to start the maintenance window.
 */
public data class AmlFilesystemResponseMaintenanceWindow(
    public val dayOfWeek: String? = null,
    public val timeOfDayUTC: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.AmlFilesystemResponseMaintenanceWindow): AmlFilesystemResponseMaintenanceWindow = AmlFilesystemResponseMaintenanceWindow(
            dayOfWeek = javaType.dayOfWeek().map({ args0 -> args0 }).orElse(null),
            timeOfDayUTC = javaType.timeOfDayUTC().map({ args0 -> args0 }).orElse(null),
        )
    }
}
