@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.Suppress

/**
 * Cache Directory Services settings.
 * @property activeDirectory Specifies settings for joining the HPC Cache to an Active Directory domain.
 * @property usernameDownload Specifies settings for Extended Groups. Extended Groups allows users to be members of more than 16 groups.
 */
public data class CacheDirectorySettingsResponse(
    public val activeDirectory: CacheActiveDirectorySettingsResponse? = null,
    public val usernameDownload: CacheUsernameDownloadSettingsResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.CacheDirectorySettingsResponse): CacheDirectorySettingsResponse = CacheDirectorySettingsResponse(
            activeDirectory = javaType.activeDirectory().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagecache.kotlin.outputs.CacheActiveDirectorySettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            usernameDownload = javaType.usernameDownload().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagecache.kotlin.outputs.CacheUsernameDownloadSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
