@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Cache encryption settings.
 * @property keyEncryptionKey Specifies the location of the key encryption key in key vault.
 * @property rotationToLatestKeyVersionEnabled Specifies whether the service will automatically rotate to the newest version of the key in the key vault.
 */
public data class CacheEncryptionSettingsResponse(
    public val keyEncryptionKey: KeyVaultKeyReferenceResponse? = null,
    public val rotationToLatestKeyVersionEnabled: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.CacheEncryptionSettingsResponse): CacheEncryptionSettingsResponse = CacheEncryptionSettingsResponse(
            keyEncryptionKey = javaType.keyEncryptionKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagecache.kotlin.outputs.KeyVaultKeyReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rotationToLatestKeyVersionEnabled = javaType.rotationToLatestKeyVersionEnabled().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
