@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Cache network settings.
 * @property dnsSearchDomain DNS search domain
 * @property dnsServers DNS servers for the cache to use.  It will be set from the network configuration if no value is provided.
 * @property mtu The IPv4 maximum transmission unit configured for the subnet.
 * @property ntpServer NTP server IP Address or FQDN for the cache to use. The default is time.windows.com.
 * @property utilityAddresses Array of additional IP addresses used by this cache.
 */
public data class CacheNetworkSettingsResponse(
    public val dnsSearchDomain: String? = null,
    public val dnsServers: List<String>? = null,
    public val mtu: Int? = null,
    public val ntpServer: String? = null,
    public val utilityAddresses: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.CacheNetworkSettingsResponse): CacheNetworkSettingsResponse = CacheNetworkSettingsResponse(
            dnsSearchDomain = javaType.dnsSearchDomain().map({ args0 -> args0 }).orElse(null),
            dnsServers = javaType.dnsServers().map({ args0 -> args0 }),
            mtu = javaType.mtu().map({ args0 -> args0 }).orElse(null),
            ntpServer = javaType.ntpServer().map({ args0 -> args0 }).orElse(null),
            utilityAddresses = javaType.utilityAddresses().map({ args0 -> args0 }),
        )
    }
}
