@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * When present, these are the credentials for the secure LDAP connection.
 * @property bindDn The Bind Distinguished Name identity to be used in the secure LDAP connection. This value is stored encrypted and not returned on response.
 * @property bindPassword The Bind password to be used in the secure LDAP connection. This value is stored encrypted and not returned on response.
 */
public data class CacheUsernameDownloadSettingsResponseCredentials(
    public val bindDn: String? = null,
    public val bindPassword: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.CacheUsernameDownloadSettingsResponseCredentials): CacheUsernameDownloadSettingsResponseCredentials =
            CacheUsernameDownloadSettingsResponseCredentials(
                bindDn = javaType.bindDn().map({ args0 -> args0 }).orElse(null),
                bindPassword = javaType.bindPassword().map({ args0 -> args0 }).orElse(null),
            )
    }
}
