@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Outstanding conditions that will need to be resolved.
 * @property message The issue requiring attention.
 * @property timestamp The time when the condition was raised.
 */
public data class ConditionResponse(
    public val message: String,
    public val timestamp: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.ConditionResponse): ConditionResponse = ConditionResponse(
            message = javaType.message(),
            timestamp = javaType.timestamp(),
        )
    }
}
