@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * An import job instance. Follows Azure Resource Manager standards: https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/resource-api-reference.md
 * @property blobsImportedPerSecond A recent and frequently updated rate of total files, directories, and symlinks imported per second.
 * @property blobsWalkedPerSecond A recent and frequently updated rate of blobs walked per second.
 * @property conflictResolutionMode How the import job will handle conflicts. For example, if the import job is trying to bring in a directory, but a file is at that path, how it handles it. Fail indicates that the import job should stop immediately and not do anything with the conflict. Skip indicates that it should pass over the conflict. OverwriteIfDirty causes the import job to delete and re-import the file or directory if it is a conflicting type, is dirty, or was not previously imported. OverwriteAlways extends OverwriteIfDirty to include releasing files that had been restored but were not dirty. Please reference https://learn.microsoft.com/en-us/azure/azure-managed-lustre/ for a thorough explanation of these resolution modes.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property importPrefixes An array of blob paths/prefixes that get imported into the cluster namespace. It has '/' as the default value.
 * @property lastCompletionTime The time of the last completed archive operation
 * @property lastStartedTime The time the latest archive operation started
 * @property location The geo-location where the resource lives
 * @property maximumErrors Total non-conflict oriented errors the import job will tolerate before exiting with failure. -1 means infinite. 0 means exit immediately and is the default.
 * @property name The name of the resource
 * @property provisioningState ARM provisioning state.
 * @property state The state of the import job. InProgress indicates the import is still running. Canceled indicates it has been canceled by the user. Completed indicates import finished, successfully importing all discovered blobs into the Lustre namespace. CompletedPartial indicates the import finished but some blobs either were found to be conflicting and could not be imported or other errors were encountered. Failed means the import was unable to complete due to a fatal error.
 * @property statusMessage The status message of the import job.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property totalBlobsImported The total blobs that have been imported since import began.
 * @property totalBlobsWalked The total blob objects walked.
 * @property totalConflicts Number of conflicts in the import job.
 * @property totalErrors Number of errors in the import job.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetImportJobResult(
    public val blobsImportedPerSecond: Double,
    public val blobsWalkedPerSecond: Double,
    public val conflictResolutionMode: String? = null,
    public val id: String,
    public val importPrefixes: List<String>? = null,
    public val lastCompletionTime: String,
    public val lastStartedTime: String,
    public val location: String,
    public val maximumErrors: Int? = null,
    public val name: String,
    public val provisioningState: String,
    public val state: String,
    public val statusMessage: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val totalBlobsImported: Double,
    public val totalBlobsWalked: Double,
    public val totalConflicts: Int,
    public val totalErrors: Int,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.GetImportJobResult): GetImportJobResult = GetImportJobResult(
            blobsImportedPerSecond = javaType.blobsImportedPerSecond(),
            blobsWalkedPerSecond = javaType.blobsWalkedPerSecond(),
            conflictResolutionMode = javaType.conflictResolutionMode().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            importPrefixes = javaType.importPrefixes().map({ args0 -> args0 }),
            lastCompletionTime = javaType.lastCompletionTime(),
            lastStartedTime = javaType.lastStartedTime(),
            location = javaType.location(),
            maximumErrors = javaType.maximumErrors().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            state = javaType.state(),
            statusMessage = javaType.statusMessage(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.storagecache.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            totalBlobsImported = javaType.totalBlobsImported(),
            totalBlobsWalked = javaType.totalBlobsWalked(),
            totalConflicts = javaType.totalConflicts(),
            totalErrors = javaType.totalErrors(),
            type = javaType.type(),
        )
    }
}
