@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Type of the Storage Target.
 * @property allocationPercentage The percentage of cache space allocated for this storage target
 * @property blobNfs Properties when targetType is blobNfs.
 * @property clfs Properties when targetType is clfs.
 * @property id Resource ID of the Storage Target.
 * @property junctions List of cache namespace junctions to target for namespace associations.
 * @property location Region name string.
 * @property name Name of the Storage Target.
 * @property nfs3 Properties when targetType is nfs3.
 * @property provisioningState ARM provisioning state, see https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/Addendum.md#provisioningstate-property
 * @property state Storage target operational state.
 * @property systemData The system meta data relating to this resource.
 * @property targetType Type of the Storage Target.
 * @property type Type of the Storage Target; Microsoft.StorageCache/Cache/StorageTarget
 * @property unknown Properties when targetType is unknown.
 */
public data class GetStorageTargetResult(
    public val allocationPercentage: Int,
    public val blobNfs: BlobNfsTargetResponse? = null,
    public val clfs: ClfsTargetResponse? = null,
    public val id: String,
    public val junctions: List<NamespaceJunctionResponse>? = null,
    public val location: String,
    public val name: String,
    public val nfs3: Nfs3TargetResponse? = null,
    public val provisioningState: String,
    public val state: String? = null,
    public val systemData: SystemDataResponse,
    public val targetType: String,
    public val type: String,
    public val unknown: UnknownTargetResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.GetStorageTargetResult): GetStorageTargetResult = GetStorageTargetResult(
            allocationPercentage = javaType.allocationPercentage(),
            blobNfs = javaType.blobNfs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagecache.kotlin.outputs.BlobNfsTargetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            clfs = javaType.clfs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagecache.kotlin.outputs.ClfsTargetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            junctions = javaType.junctions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagecache.kotlin.outputs.NamespaceJunctionResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location(),
            name = javaType.name(),
            nfs3 = javaType.nfs3().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagecache.kotlin.outputs.Nfs3TargetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.storagecache.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            targetType = javaType.targetType(),
            type = javaType.type(),
            unknown = javaType.unknown().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagecache.kotlin.outputs.UnknownTargetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
