@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A namespace junction.
 * @property namespacePath Namespace path on a cache for a Storage Target.
 * @property nfsAccessPolicy Name of the access policy applied to this junction.
 * @property nfsExport NFS export where targetPath exists.
 * @property targetPath Path in Storage Target to which namespacePath points.
 */
public data class NamespaceJunctionResponse(
    public val namespacePath: String? = null,
    public val nfsAccessPolicy: String? = null,
    public val nfsExport: String? = null,
    public val targetPath: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.NamespaceJunctionResponse): NamespaceJunctionResponse = NamespaceJunctionResponse(
            namespacePath = javaType.namespacePath().map({ args0 -> args0 }).orElse(null),
            nfsAccessPolicy = javaType.nfsAccessPolicy().map({ args0 -> args0 }).orElse(null),
            nfsExport = javaType.nfsExport().map({ args0 -> args0 }).orElse(null),
            targetPath = javaType.targetPath().map({ args0 -> args0 }).orElse(null),
        )
    }
}
