@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Properties pertaining to the Nfs3Target
 * @property target IP address or host name of an NFSv3 host (e.g., 10.0.44.44).
 * @property usageModel Identifies the StorageCache usage model to be used for this storage target.
 * @property verificationTimer Amount of time (in seconds) the cache waits before it checks the back-end storage for file updates.
 * @property writeBackTimer Amount of time (in seconds) the cache waits after the last file change before it copies the changed file to back-end storage.
 */
public data class Nfs3TargetResponse(
    public val target: String? = null,
    public val usageModel: String? = null,
    public val verificationTimer: Int? = null,
    public val writeBackTimer: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.Nfs3TargetResponse): Nfs3TargetResponse = Nfs3TargetResponse(
            target = javaType.target().map({ args0 -> args0 }).orElse(null),
            usageModel = javaType.usageModel().map({ args0 -> args0 }).orElse(null),
            verificationTimer = javaType.verificationTimer().map({ args0 -> args0 }).orElse(null),
            writeBackTimer = javaType.writeBackTimer().map({ args0 -> args0 }).orElse(null),
        )
    }
}
