@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A set of rules describing access policies applied to NFSv3 clients of the cache.
 * @property accessRules The set of rules describing client accesses allowed under this policy.
 * @property name Name identifying this policy. Access Policy names are not case sensitive.
 */
public data class NfsAccessPolicyResponse(
    public val accessRules: List<NfsAccessRuleResponse>,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.NfsAccessPolicyResponse): NfsAccessPolicyResponse = NfsAccessPolicyResponse(
            accessRules = javaType.accessRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagecache.kotlin.outputs.NfsAccessRuleResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
        )
    }
}
