@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * A priming job instance.
 * @property primingJobDetails The job details or error information if any.
 * @property primingJobId The unique identifier of the priming job.
 * @property primingJobName The priming job name.
 * @property primingJobPercentComplete The current progress of the priming job, as a percentage.
 * @property primingJobState The state of the priming operation.
 * @property primingJobStatus The status code of the priming job.
 */
public data class PrimingJobResponse(
    public val primingJobDetails: String,
    public val primingJobId: String,
    public val primingJobName: String,
    public val primingJobPercentComplete: Double,
    public val primingJobState: String,
    public val primingJobStatus: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.PrimingJobResponse): PrimingJobResponse = PrimingJobResponse(
            primingJobDetails = javaType.primingJobDetails(),
            primingJobId = javaType.primingJobId(),
            primingJobName = javaType.primingJobName(),
            primingJobPercentComplete = javaType.primingJobPercentComplete(),
            primingJobState = javaType.primingJobState(),
            primingJobStatus = javaType.primingJobStatus(),
        )
    }
}
