@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagecache.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Properties pertaining to the UnknownTarget
 * @property attributes Dictionary of string->string pairs containing information about the Storage Target.
 */
public data class UnknownTargetResponse(
    public val attributes: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagecache.outputs.UnknownTargetResponse): UnknownTargetResponse = UnknownTargetResponse(
            attributes = javaType.attributes().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
