@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagemover.kotlin

import com.pulumi.azurenative.storagemover.EndpointArgs.builder
import com.pulumi.azurenative.storagemover.kotlin.inputs.AzureStorageBlobContainerEndpointPropertiesArgs
import com.pulumi.azurenative.storagemover.kotlin.inputs.NfsMountEndpointPropertiesArgs
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Endpoint resource, which contains information about file sources and targets.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2022-07-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-10-01.
 * ## Example Usage
 * ### Endpoints_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var endpoint = new AzureNative.StorageMover.Endpoint("endpoint", new()
 *     {
 *         EndpointName = "examples-endpointName",
 *         Properties = new AzureNative.StorageMover.Inputs.AzureStorageBlobContainerEndpointPropertiesArgs
 *         {
 *             BlobContainerName = "examples-blobContainerName",
 *             Description = "Example Storage Container Endpoint Description",
 *             EndpointType = "AzureStorageBlobContainer",
 *             StorageAccountResourceId = "/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/examples-rg/providers/Microsoft.Storage/storageAccounts/examples-storageAccountName/",
 *         },
 *         ResourceGroupName = "examples-rg",
 *         StorageMoverName = "examples-storageMoverName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagemover/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagemover.NewEndpoint(ctx, "endpoint", &storagemover.EndpointArgs{
 * 			EndpointName: pulumi.String("examples-endpointName"),
 * 			Properties: storagemover.AzureStorageBlobContainerEndpointProperties{
 * 				BlobContainerName:        "examples-blobContainerName",
 * 				Description:              "Example Storage Container Endpoint Description",
 * 				EndpointType:             "AzureStorageBlobContainer",
 * 				StorageAccountResourceId: "/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/examples-rg/providers/Microsoft.Storage/storageAccounts/examples-storageAccountName/",
 * 			},
 * 			ResourceGroupName: pulumi.String("examples-rg"),
 * 			StorageMoverName:  pulumi.String("examples-storageMoverName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagemover.Endpoint;
 * import com.pulumi.azurenative.storagemover.EndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var endpoint = new Endpoint("endpoint", EndpointArgs.builder()
 *             .endpointName("examples-endpointName")
 *             .properties(AzureStorageBlobContainerEndpointPropertiesArgs.builder()
 *                 .blobContainerName("examples-blobContainerName")
 *                 .description("Example Storage Container Endpoint Description")
 *                 .endpointType("AzureStorageBlobContainer")
 *                 .storageAccountResourceId("/subscriptions/11111111-2222-3333-4444-555555555555/resourceGroups/examples-rg/providers/Microsoft.Storage/storageAccounts/examples-storageAccountName/")
 *                 .build())
 *             .resourceGroupName("examples-rg")
 *             .storageMoverName("examples-storageMoverName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagemover:Endpoint examples-endpointName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StorageMover/storageMovers/{storageMoverName}/endpoints/{endpointName}
 * ```
 * @property endpointName The name of the Endpoint resource.
 * @property properties The resource specific properties for the Storage Mover resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageMoverName The name of the Storage Mover resource.
 */
public data class EndpointArgs(
    public val endpointName: Output<String>? = null,
    public val properties: Output<Either<AzureStorageBlobContainerEndpointPropertiesArgs, NfsMountEndpointPropertiesArgs>>? =
        null,
    public val resourceGroupName: Output<String>? = null,
    public val storageMoverName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagemover.EndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.storagemover.EndpointArgs =
        com.pulumi.azurenative.storagemover.EndpointArgs.builder()
            .endpointName(endpointName?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .storageMoverName(storageMoverName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointArgs].
 */
@PulumiTagMarker
public class EndpointArgsBuilder internal constructor() {
    private var endpointName: Output<String>? = null

    private var properties:
        Output<Either<AzureStorageBlobContainerEndpointPropertiesArgs, NfsMountEndpointPropertiesArgs>>? =
        null

    private var resourceGroupName: Output<String>? = null

    private var storageMoverName: Output<String>? = null

    /**
     * @param value The name of the Endpoint resource.
     */
    @JvmName("tmqgkhqcpiyprqnv")
    public suspend fun endpointName(`value`: Output<String>) {
        this.endpointName = value
    }

    /**
     * @param value The resource specific properties for the Storage Mover resource.
     */
    @JvmName("gjcnaynincnxnqdk")
    public suspend fun properties(`value`: Output<Either<AzureStorageBlobContainerEndpointPropertiesArgs, NfsMountEndpointPropertiesArgs>>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bruucpdsmrjmdkke")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Storage Mover resource.
     */
    @JvmName("wpobhkqjoagqeuew")
    public suspend fun storageMoverName(`value`: Output<String>) {
        this.storageMoverName = value
    }

    /**
     * @param value The name of the Endpoint resource.
     */
    @JvmName("yjokkbggmkvtmdho")
    public suspend fun endpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointName = mapped
    }

    /**
     * @param value The resource specific properties for the Storage Mover resource.
     */
    @JvmName("nlfhubfeyunvyjgs")
    public suspend fun properties(`value`: Either<AzureStorageBlobContainerEndpointPropertiesArgs, NfsMountEndpointPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The resource specific properties for the Storage Mover resource.
     */
    @JvmName("esqcelgugjrjmune")
    public fun properties(`value`: AzureStorageBlobContainerEndpointPropertiesArgs) {
        val toBeMapped = Either.ofLeft<
            AzureStorageBlobContainerEndpointPropertiesArgs,
            NfsMountEndpointPropertiesArgs,
            >(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The resource specific properties for the Storage Mover resource.
     */
    @JvmName("mokdocpomfrimjkv")
    public fun properties(`value`: NfsMountEndpointPropertiesArgs) {
        val toBeMapped = Either.ofRight<
            AzureStorageBlobContainerEndpointPropertiesArgs,
            NfsMountEndpointPropertiesArgs,
            >(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ddqcexfoqlscggxh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Storage Mover resource.
     */
    @JvmName("dqhbarncmppmphqp")
    public suspend fun storageMoverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageMoverName = mapped
    }

    internal fun build(): EndpointArgs = EndpointArgs(
        endpointName = endpointName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        storageMoverName = storageMoverName,
    )
}
