@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagemover.kotlin.inputs

import com.pulumi.azurenative.storagemover.inputs.AzureStorageBlobContainerEndpointPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property blobContainerName The name of the Storage blob container that is the target destination.
 * @property description A description for the Endpoint.
 * @property endpointType The Endpoint resource type.
 * Expected value is 'AzureStorageBlobContainer'.
 * @property storageAccountResourceId The Azure Resource ID of the storage account that is the target destination.
 */
public data class AzureStorageBlobContainerEndpointPropertiesArgs(
    public val blobContainerName: Output<String>,
    public val description: Output<String>? = null,
    public val endpointType: Output<String>,
    public val storageAccountResourceId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.storagemover.inputs.AzureStorageBlobContainerEndpointPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.storagemover.inputs.AzureStorageBlobContainerEndpointPropertiesArgs =
        com.pulumi.azurenative.storagemover.inputs.AzureStorageBlobContainerEndpointPropertiesArgs.builder()
            .blobContainerName(blobContainerName.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .endpointType(endpointType.applyValue({ args0 -> args0 }))
            .storageAccountResourceId(storageAccountResourceId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureStorageBlobContainerEndpointPropertiesArgs].
 */
@PulumiTagMarker
public class AzureStorageBlobContainerEndpointPropertiesArgsBuilder internal constructor() {
    private var blobContainerName: Output<String>? = null

    private var description: Output<String>? = null

    private var endpointType: Output<String>? = null

    private var storageAccountResourceId: Output<String>? = null

    /**
     * @param value The name of the Storage blob container that is the target destination.
     */
    @JvmName("xsnpfohaoocyqxij")
    public suspend fun blobContainerName(`value`: Output<String>) {
        this.blobContainerName = value
    }

    /**
     * @param value A description for the Endpoint.
     */
    @JvmName("hemvprqyhrcciaht")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The Endpoint resource type.
     * Expected value is 'AzureStorageBlobContainer'.
     */
    @JvmName("xctyyiopqnlowwxw")
    public suspend fun endpointType(`value`: Output<String>) {
        this.endpointType = value
    }

    /**
     * @param value The Azure Resource ID of the storage account that is the target destination.
     */
    @JvmName("cyebxbjsxqrgrdtu")
    public suspend fun storageAccountResourceId(`value`: Output<String>) {
        this.storageAccountResourceId = value
    }

    /**
     * @param value The name of the Storage blob container that is the target destination.
     */
    @JvmName("bvqystdowrkcjktk")
    public suspend fun blobContainerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blobContainerName = mapped
    }

    /**
     * @param value A description for the Endpoint.
     */
    @JvmName("ahgntwpwqvtewjcj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The Endpoint resource type.
     * Expected value is 'AzureStorageBlobContainer'.
     */
    @JvmName("iddqkxssuafrvigv")
    public suspend fun endpointType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointType = mapped
    }

    /**
     * @param value The Azure Resource ID of the storage account that is the target destination.
     */
    @JvmName("rfdoivngjsirkgtc")
    public suspend fun storageAccountResourceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountResourceId = mapped
    }

    internal fun build(): AzureStorageBlobContainerEndpointPropertiesArgs =
        AzureStorageBlobContainerEndpointPropertiesArgs(
            blobContainerName = blobContainerName ?: throw PulumiNullFieldException("blobContainerName"),
            description = description,
            endpointType = endpointType ?: throw PulumiNullFieldException("endpointType"),
            storageAccountResourceId = storageAccountResourceId ?: throw
                PulumiNullFieldException("storageAccountResourceId"),
        )
}
