@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagemover.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * The Agent resource.
 * @property agentStatus The Agent status.
 * @property agentVersion The Agent version.
 * @property arcResourceId The fully qualified resource ID of the Hybrid Compute resource for the Agent.
 * @property arcVmUuid The VM UUID of the Hybrid Compute resource for the Agent.
 * @property description A description for the Agent.
 * @property errorDetails
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property lastStatusUpdate The last updated time of the Agent status.
 * @property localIPAddress Local IP address reported by the Agent.
 * @property memoryInMB Available memory reported by the Agent, in MB.
 * @property name The name of the resource
 * @property numberOfCores Available compute cores reported by the Agent.
 * @property provisioningState The provisioning state of this resource.
 * @property systemData Resource system metadata.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property uptimeInSeconds Uptime of the Agent in seconds.
 */
public data class GetAgentResult(
    public val agentStatus: String,
    public val agentVersion: String,
    public val arcResourceId: String,
    public val arcVmUuid: String,
    public val description: String? = null,
    public val errorDetails: AgentPropertiesResponseErrorDetails,
    public val id: String,
    public val lastStatusUpdate: String,
    public val localIPAddress: String,
    public val memoryInMB: Double,
    public val name: String,
    public val numberOfCores: Double,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val uptimeInSeconds: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagemover.outputs.GetAgentResult): GetAgentResult = GetAgentResult(
            agentStatus = javaType.agentStatus(),
            agentVersion = javaType.agentVersion(),
            arcResourceId = javaType.arcResourceId(),
            arcVmUuid = javaType.arcVmUuid(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            errorDetails = javaType.errorDetails().let({ args0 ->
                com.pulumi.azurenative.storagemover.kotlin.outputs.AgentPropertiesResponseErrorDetails.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            lastStatusUpdate = javaType.lastStatusUpdate(),
            localIPAddress = javaType.localIPAddress(),
            memoryInMB = javaType.memoryInMB(),
            name = javaType.name(),
            numberOfCores = javaType.numberOfCores(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.storagemover.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            uptimeInSeconds = javaType.uptimeInSeconds(),
        )
    }
}
