@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagemover.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * The Endpoint resource, which contains information about file sources and targets.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property properties The resource specific properties for the Storage Mover resource.
 * @property systemData Resource system metadata.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetEndpointResult(
    public val id: String,
    public val name: String,
    public val properties: Either<AzureStorageBlobContainerEndpointPropertiesResponse, NfsMountEndpointPropertiesResponse>,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagemover.outputs.GetEndpointResult): GetEndpointResult = GetEndpointResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.storagemover.kotlin.outputs.AzureStorageBlobContainerEndpointPropertiesResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.storagemover.kotlin.outputs.NfsMountEndpointPropertiesResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.storagemover.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
