@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagemover.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description A description for the Endpoint.
 * @property endpointType The Endpoint resource type.
 * Expected value is 'NfsMount'.
 * @property export The directory being exported from the server.
 * @property host The host name or IP address of the server exporting the file system.
 * @property nfsVersion The NFS protocol version.
 * @property provisioningState The provisioning state of this resource.
 */
public data class NfsMountEndpointPropertiesResponse(
    public val description: String? = null,
    public val endpointType: String,
    public val export: String,
    public val host: String,
    public val nfsVersion: String? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagemover.outputs.NfsMountEndpointPropertiesResponse): NfsMountEndpointPropertiesResponse = NfsMountEndpointPropertiesResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            endpointType = javaType.endpointType(),
            export = javaType.export(),
            host = javaType.host(),
            nfsVersion = javaType.nfsVersion().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
        )
    }
}
