@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagepool.kotlin

import com.pulumi.azurenative.storagepool.kotlin.outputs.AclResponse
import com.pulumi.azurenative.storagepool.kotlin.outputs.IscsiLunResponse
import com.pulumi.azurenative.storagepool.kotlin.outputs.SystemMetadataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.storagepool.kotlin.outputs.AclResponse.Companion.toKotlin as aclResponseToKotlin
import com.pulumi.azurenative.storagepool.kotlin.outputs.IscsiLunResponse.Companion.toKotlin as iscsiLunResponseToKotlin
import com.pulumi.azurenative.storagepool.kotlin.outputs.SystemMetadataResponse.Companion.toKotlin as systemMetadataResponseToKotlin

/**
 * Builder for [IscsiTarget].
 */
@PulumiTagMarker
public class IscsiTargetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IscsiTargetArgs = IscsiTargetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IscsiTargetArgsBuilder.() -> Unit) {
        val builder = IscsiTargetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): IscsiTarget {
        val builtJavaResource = com.pulumi.azurenative.storagepool.IscsiTarget(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return IscsiTarget(builtJavaResource)
    }
}

/**
 * Response for iSCSI Target requests.
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-03-15-preview.
 * Other available API versions: 2020-03-15-preview.
 * ## Example Usage
 * ### Create or Update iSCSI Target
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iscsiTarget = new AzureNative.StoragePool.IscsiTarget("iscsiTarget", new()
 *     {
 *         AclMode = AzureNative.StoragePool.IscsiTargetAclMode.Dynamic,
 *         DiskPoolName = "myDiskPool",
 *         IscsiTargetName = "myIscsiTarget",
 *         Luns = new[]
 *         {
 *             new AzureNative.StoragePool.Inputs.IscsiLunArgs
 *             {
 *                 ManagedDiskAzureResourceId = "/subscriptions/11111111-1111-1111-1111-111111111111/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vm-name_DataDisk_1",
 *                 Name = "lun0",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         TargetIqn = "iqn.2005-03.org.iscsi:server1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagepool/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagepool.NewIscsiTarget(ctx, "iscsiTarget", &storagepool.IscsiTargetArgs{
 * 			AclMode:         pulumi.String(storagepool.IscsiTargetAclModeDynamic),
 * 			DiskPoolName:    pulumi.String("myDiskPool"),
 * 			IscsiTargetName: pulumi.String("myIscsiTarget"),
 * 			Luns: storagepool.IscsiLunArray{
 * 				&storagepool.IscsiLunArgs{
 * 					ManagedDiskAzureResourceId: pulumi.String("/subscriptions/11111111-1111-1111-1111-111111111111/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vm-name_DataDisk_1"),
 * 					Name:                       pulumi.String("lun0"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			TargetIqn:         pulumi.String("iqn.2005-03.org.iscsi:server1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagepool.IscsiTarget;
 * import com.pulumi.azurenative.storagepool.IscsiTargetArgs;
 * import com.pulumi.azurenative.storagepool.inputs.IscsiLunArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iscsiTarget = new IscsiTarget("iscsiTarget", IscsiTargetArgs.builder()
 *             .aclMode("Dynamic")
 *             .diskPoolName("myDiskPool")
 *             .iscsiTargetName("myIscsiTarget")
 *             .luns(IscsiLunArgs.builder()
 *                 .managedDiskAzureResourceId("/subscriptions/11111111-1111-1111-1111-111111111111/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vm-name_DataDisk_1")
 *                 .name("lun0")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .targetIqn("iqn.2005-03.org.iscsi:server1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagepool:IscsiTarget myIscsiTarget /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StoragePool/diskPools/{diskPoolName}/iscsiTargets/{iscsiTargetName}
 * ```
 */
public class IscsiTarget internal constructor(
    override val javaResource: com.pulumi.azurenative.storagepool.IscsiTarget,
) : KotlinCustomResource(javaResource, IscsiTargetMapper) {
    /**
     * Mode for Target connectivity.
     */
    public val aclMode: Output<String>
        get() = javaResource.aclMode().applyValue({ args0 -> args0 })

    /**
     * List of private IPv4 addresses to connect to the iSCSI Target.
     */
    public val endpoints: Output<List<String>>?
        get() = javaResource.endpoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * List of LUNs to be exposed through iSCSI Target.
     */
    public val luns: Output<List<IscsiLunResponse>>?
        get() = javaResource.luns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> iscsiLunResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Azure resource id. Indicates if this resource is managed by another Azure resource.
     */
    public val managedBy: Output<String>
        get() = javaResource.managedBy().applyValue({ args0 -> args0 })

    /**
     * List of Azure resource ids that manage this resource.
     */
    public val managedByExtended: Output<List<String>>
        get() = javaResource.managedByExtended().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The port used by iSCSI Target portal group.
     */
    public val port: Output<Int>?
        get() = javaResource.port().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * State of the operation on the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * List of identifiers for active sessions on the iSCSI target
     */
    public val sessions: Output<List<String>>
        get() = javaResource.sessions().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Access Control List (ACL) for an iSCSI Target; defines LUN masking policy
     */
    public val staticAcls: Output<List<AclResponse>>?
        get() = javaResource.staticAcls().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> aclResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Operational status of the iSCSI Target.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Resource metadata required by ARM RPC
     */
    public val systemData: Output<SystemMetadataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemMetadataResponseToKotlin(args0)
            })
        })

    /**
     * iSCSI Target IQN (iSCSI Qualified Name); example: "iqn.2005-03.org.iscsi:server".
     */
    public val targetIqn: Output<String>
        get() = javaResource.targetIqn().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object IscsiTargetMapper : ResourceMapper<IscsiTarget> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storagepool.IscsiTarget::class == javaResource::class

    override fun map(javaResource: Resource): IscsiTarget = IscsiTarget(
        javaResource as
            com.pulumi.azurenative.storagepool.IscsiTarget,
    )
}

/**
 * @see [IscsiTarget].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [IscsiTarget].
 */
public suspend fun iscsiTarget(name: String, block: suspend IscsiTargetResourceBuilder.() -> Unit): IscsiTarget {
    val builder = IscsiTargetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [IscsiTarget].
 * @param name The _unique_ name of the resulting resource.
 */
public fun iscsiTarget(name: String): IscsiTarget {
    val builder = IscsiTargetResourceBuilder()
    builder.name(name)
    return builder.build()
}
