@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagepool.kotlin

import com.pulumi.azurenative.storagepool.IscsiTargetArgs.builder
import com.pulumi.azurenative.storagepool.kotlin.enums.IscsiTargetAclMode
import com.pulumi.azurenative.storagepool.kotlin.inputs.AclArgs
import com.pulumi.azurenative.storagepool.kotlin.inputs.AclArgsBuilder
import com.pulumi.azurenative.storagepool.kotlin.inputs.IscsiLunArgs
import com.pulumi.azurenative.storagepool.kotlin.inputs.IscsiLunArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Response for iSCSI Target requests.
 * Azure REST API version: 2021-08-01. Prior API version in Azure Native 1.x: 2020-03-15-preview.
 * Other available API versions: 2020-03-15-preview.
 * ## Example Usage
 * ### Create or Update iSCSI Target
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var iscsiTarget = new AzureNative.StoragePool.IscsiTarget("iscsiTarget", new()
 *     {
 *         AclMode = AzureNative.StoragePool.IscsiTargetAclMode.Dynamic,
 *         DiskPoolName = "myDiskPool",
 *         IscsiTargetName = "myIscsiTarget",
 *         Luns = new[]
 *         {
 *             new AzureNative.StoragePool.Inputs.IscsiLunArgs
 *             {
 *                 ManagedDiskAzureResourceId = "/subscriptions/11111111-1111-1111-1111-111111111111/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vm-name_DataDisk_1",
 *                 Name = "lun0",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         TargetIqn = "iqn.2005-03.org.iscsi:server1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storagepool/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagepool.NewIscsiTarget(ctx, "iscsiTarget", &storagepool.IscsiTargetArgs{
 * 			AclMode:         pulumi.String(storagepool.IscsiTargetAclModeDynamic),
 * 			DiskPoolName:    pulumi.String("myDiskPool"),
 * 			IscsiTargetName: pulumi.String("myIscsiTarget"),
 * 			Luns: storagepool.IscsiLunArray{
 * 				&storagepool.IscsiLunArgs{
 * 					ManagedDiskAzureResourceId: pulumi.String("/subscriptions/11111111-1111-1111-1111-111111111111/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vm-name_DataDisk_1"),
 * 					Name:                       pulumi.String("lun0"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			TargetIqn:         pulumi.String("iqn.2005-03.org.iscsi:server1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storagepool.IscsiTarget;
 * import com.pulumi.azurenative.storagepool.IscsiTargetArgs;
 * import com.pulumi.azurenative.storagepool.inputs.IscsiLunArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var iscsiTarget = new IscsiTarget("iscsiTarget", IscsiTargetArgs.builder()
 *             .aclMode("Dynamic")
 *             .diskPoolName("myDiskPool")
 *             .iscsiTargetName("myIscsiTarget")
 *             .luns(IscsiLunArgs.builder()
 *                 .managedDiskAzureResourceId("/subscriptions/11111111-1111-1111-1111-111111111111/resourceGroups/myResourceGroup/providers/Microsoft.Compute/disks/vm-name_DataDisk_1")
 *                 .name("lun0")
 *                 .build())
 *             .resourceGroupName("myResourceGroup")
 *             .targetIqn("iqn.2005-03.org.iscsi:server1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storagepool:IscsiTarget myIscsiTarget /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StoragePool/diskPools/{diskPoolName}/iscsiTargets/{iscsiTargetName}
 * ```
 * @property aclMode Mode for Target connectivity.
 * @property diskPoolName The name of the Disk Pool.
 * @property iscsiTargetName The name of the iSCSI Target.
 * @property luns List of LUNs to be exposed through iSCSI Target.
 * @property managedBy Azure resource id. Indicates if this resource is managed by another Azure resource.
 * @property managedByExtended List of Azure resource ids that manage this resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property staticAcls Access Control List (ACL) for an iSCSI Target; defines LUN masking policy
 * @property targetIqn iSCSI Target IQN (iSCSI Qualified Name); example: "iqn.2005-03.org.iscsi:server".
 */
public data class IscsiTargetArgs(
    public val aclMode: Output<Either<String, IscsiTargetAclMode>>? = null,
    public val diskPoolName: Output<String>? = null,
    public val iscsiTargetName: Output<String>? = null,
    public val luns: Output<List<IscsiLunArgs>>? = null,
    public val managedBy: Output<String>? = null,
    public val managedByExtended: Output<List<String>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val staticAcls: Output<List<AclArgs>>? = null,
    public val targetIqn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storagepool.IscsiTargetArgs> {
    override fun toJava(): com.pulumi.azurenative.storagepool.IscsiTargetArgs =
        com.pulumi.azurenative.storagepool.IscsiTargetArgs.builder()
            .aclMode(
                aclMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .diskPoolName(diskPoolName?.applyValue({ args0 -> args0 }))
            .iscsiTargetName(iscsiTargetName?.applyValue({ args0 -> args0 }))
            .luns(luns?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .managedBy(managedBy?.applyValue({ args0 -> args0 }))
            .managedByExtended(managedByExtended?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .staticAcls(
                staticAcls?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .targetIqn(targetIqn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IscsiTargetArgs].
 */
@PulumiTagMarker
public class IscsiTargetArgsBuilder internal constructor() {
    private var aclMode: Output<Either<String, IscsiTargetAclMode>>? = null

    private var diskPoolName: Output<String>? = null

    private var iscsiTargetName: Output<String>? = null

    private var luns: Output<List<IscsiLunArgs>>? = null

    private var managedBy: Output<String>? = null

    private var managedByExtended: Output<List<String>>? = null

    private var resourceGroupName: Output<String>? = null

    private var staticAcls: Output<List<AclArgs>>? = null

    private var targetIqn: Output<String>? = null

    /**
     * @param value Mode for Target connectivity.
     */
    @JvmName("trvwkbsncdjgqovq")
    public suspend fun aclMode(`value`: Output<Either<String, IscsiTargetAclMode>>) {
        this.aclMode = value
    }

    /**
     * @param value The name of the Disk Pool.
     */
    @JvmName("vawgtyndaogpwpnd")
    public suspend fun diskPoolName(`value`: Output<String>) {
        this.diskPoolName = value
    }

    /**
     * @param value The name of the iSCSI Target.
     */
    @JvmName("xrrqygqejkkxkfwi")
    public suspend fun iscsiTargetName(`value`: Output<String>) {
        this.iscsiTargetName = value
    }

    /**
     * @param value List of LUNs to be exposed through iSCSI Target.
     */
    @JvmName("gauwevwdclswxxjs")
    public suspend fun luns(`value`: Output<List<IscsiLunArgs>>) {
        this.luns = value
    }

    @JvmName("eheqkgwnimeewlhm")
    public suspend fun luns(vararg values: Output<IscsiLunArgs>) {
        this.luns = Output.all(values.asList())
    }

    /**
     * @param values List of LUNs to be exposed through iSCSI Target.
     */
    @JvmName("qlmfyyqjfmiqnyyp")
    public suspend fun luns(values: List<Output<IscsiLunArgs>>) {
        this.luns = Output.all(values)
    }

    /**
     * @param value Azure resource id. Indicates if this resource is managed by another Azure resource.
     */
    @JvmName("ovfrviutkmbndpkm")
    public suspend fun managedBy(`value`: Output<String>) {
        this.managedBy = value
    }

    /**
     * @param value List of Azure resource ids that manage this resource.
     */
    @JvmName("evslhkllxquefdwo")
    public suspend fun managedByExtended(`value`: Output<List<String>>) {
        this.managedByExtended = value
    }

    @JvmName("havmdshxplcskqtk")
    public suspend fun managedByExtended(vararg values: Output<String>) {
        this.managedByExtended = Output.all(values.asList())
    }

    /**
     * @param values List of Azure resource ids that manage this resource.
     */
    @JvmName("uouymqyrexrvknld")
    public suspend fun managedByExtended(values: List<Output<String>>) {
        this.managedByExtended = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("frhjlyakgdyvtyoo")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Access Control List (ACL) for an iSCSI Target; defines LUN masking policy
     */
    @JvmName("teqjbmkifemdpfei")
    public suspend fun staticAcls(`value`: Output<List<AclArgs>>) {
        this.staticAcls = value
    }

    @JvmName("awglqosipdqnupdg")
    public suspend fun staticAcls(vararg values: Output<AclArgs>) {
        this.staticAcls = Output.all(values.asList())
    }

    /**
     * @param values Access Control List (ACL) for an iSCSI Target; defines LUN masking policy
     */
    @JvmName("qdiiejqkmjsffdnp")
    public suspend fun staticAcls(values: List<Output<AclArgs>>) {
        this.staticAcls = Output.all(values)
    }

    /**
     * @param value iSCSI Target IQN (iSCSI Qualified Name); example: "iqn.2005-03.org.iscsi:server".
     */
    @JvmName("wqxevfboaxxyvdej")
    public suspend fun targetIqn(`value`: Output<String>) {
        this.targetIqn = value
    }

    /**
     * @param value Mode for Target connectivity.
     */
    @JvmName("kjjrvshloqdbrdbp")
    public suspend fun aclMode(`value`: Either<String, IscsiTargetAclMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclMode = mapped
    }

    /**
     * @param value Mode for Target connectivity.
     */
    @JvmName("pcgnbjfdtqoinxtf")
    public fun aclMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IscsiTargetAclMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aclMode = mapped
    }

    /**
     * @param value Mode for Target connectivity.
     */
    @JvmName("onxnbpjsudgbhwyn")
    public fun aclMode(`value`: IscsiTargetAclMode) {
        val toBeMapped = Either.ofRight<String, IscsiTargetAclMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aclMode = mapped
    }

    /**
     * @param value The name of the Disk Pool.
     */
    @JvmName("ncgprenuhpjpnpxv")
    public suspend fun diskPoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskPoolName = mapped
    }

    /**
     * @param value The name of the iSCSI Target.
     */
    @JvmName("nstiphkmtoyuuyvu")
    public suspend fun iscsiTargetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iscsiTargetName = mapped
    }

    /**
     * @param value List of LUNs to be exposed through iSCSI Target.
     */
    @JvmName("scjhfgcoricnkuep")
    public suspend fun luns(`value`: List<IscsiLunArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.luns = mapped
    }

    /**
     * @param argument List of LUNs to be exposed through iSCSI Target.
     */
    @JvmName("abfrheewtcpcsyuk")
    public suspend fun luns(argument: List<suspend IscsiLunArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IscsiLunArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.luns = mapped
    }

    /**
     * @param argument List of LUNs to be exposed through iSCSI Target.
     */
    @JvmName("arsqvkgugsvuehir")
    public suspend fun luns(vararg argument: suspend IscsiLunArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IscsiLunArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.luns = mapped
    }

    /**
     * @param argument List of LUNs to be exposed through iSCSI Target.
     */
    @JvmName("dogugbpnhkvaoioi")
    public suspend fun luns(argument: suspend IscsiLunArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IscsiLunArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.luns = mapped
    }

    /**
     * @param values List of LUNs to be exposed through iSCSI Target.
     */
    @JvmName("jxewamkyrufqhynt")
    public suspend fun luns(vararg values: IscsiLunArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.luns = mapped
    }

    /**
     * @param value Azure resource id. Indicates if this resource is managed by another Azure resource.
     */
    @JvmName("livsqsjvovvdfmic")
    public suspend fun managedBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedBy = mapped
    }

    /**
     * @param value List of Azure resource ids that manage this resource.
     */
    @JvmName("ofnhqmircejmkpeg")
    public suspend fun managedByExtended(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedByExtended = mapped
    }

    /**
     * @param values List of Azure resource ids that manage this resource.
     */
    @JvmName("vxntnlqldoeemdfo")
    public suspend fun managedByExtended(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedByExtended = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wcghdaqmeolbkfmb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Access Control List (ACL) for an iSCSI Target; defines LUN masking policy
     */
    @JvmName("yqdvbklwihvnymgv")
    public suspend fun staticAcls(`value`: List<AclArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.staticAcls = mapped
    }

    /**
     * @param argument Access Control List (ACL) for an iSCSI Target; defines LUN masking policy
     */
    @JvmName("kmstkewigtedlfxr")
    public suspend fun staticAcls(argument: List<suspend AclArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { AclArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.staticAcls = mapped
    }

    /**
     * @param argument Access Control List (ACL) for an iSCSI Target; defines LUN masking policy
     */
    @JvmName("sprnmrhatetxprmh")
    public suspend fun staticAcls(vararg argument: suspend AclArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { AclArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.staticAcls = mapped
    }

    /**
     * @param argument Access Control List (ACL) for an iSCSI Target; defines LUN masking policy
     */
    @JvmName("jjunivfgrgteovmg")
    public suspend fun staticAcls(argument: suspend AclArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AclArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.staticAcls = mapped
    }

    /**
     * @param values Access Control List (ACL) for an iSCSI Target; defines LUN masking policy
     */
    @JvmName("pbyfwmquxaprxtsc")
    public suspend fun staticAcls(vararg values: AclArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.staticAcls = mapped
    }

    /**
     * @param value iSCSI Target IQN (iSCSI Qualified Name); example: "iqn.2005-03.org.iscsi:server".
     */
    @JvmName("dklcnwkcbeimhtnl")
    public suspend fun targetIqn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetIqn = mapped
    }

    internal fun build(): IscsiTargetArgs = IscsiTargetArgs(
        aclMode = aclMode,
        diskPoolName = diskPoolName,
        iscsiTargetName = iscsiTargetName,
        luns = luns,
        managedBy = managedBy,
        managedByExtended = managedByExtended,
        resourceGroupName = resourceGroupName,
        staticAcls = staticAcls,
        targetIqn = targetIqn,
    )
}
