@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagepool.kotlin.inputs

import com.pulumi.azurenative.storagepool.inputs.GetDiskPoolPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property diskPoolName The name of the Disk Pool.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDiskPoolPlainArgs(
    public val diskPoolName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storagepool.inputs.GetDiskPoolPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storagepool.inputs.GetDiskPoolPlainArgs =
        com.pulumi.azurenative.storagepool.inputs.GetDiskPoolPlainArgs.builder()
            .diskPoolName(diskPoolName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDiskPoolPlainArgs].
 */
@PulumiTagMarker
public class GetDiskPoolPlainArgsBuilder internal constructor() {
    private var diskPoolName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Disk Pool.
     */
    @JvmName("ujeorcsolacxvnhi")
    public suspend fun diskPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.diskPoolName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kbrouaesfhxleffn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDiskPoolPlainArgs = GetDiskPoolPlainArgs(
        diskPoolName = diskPoolName ?: throw PulumiNullFieldException("diskPoolName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
