@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagepool.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Access Control List (ACL) for an iSCSI Target; defines LUN masking policy
 * @property initiatorIqn iSCSI initiator IQN (iSCSI Qualified Name); example: "iqn.2005-03.org.iscsi:client".
 * @property mappedLuns List of LUN names mapped to the ACL.
 */
public data class AclResponse(
    public val initiatorIqn: String,
    public val mappedLuns: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagepool.outputs.AclResponse): AclResponse = AclResponse(
            initiatorIqn = javaType.initiatorIqn(),
            mappedLuns = javaType.mappedLuns().map({ args0 -> args0 }),
        )
    }
}
