@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storagepool.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Response for Disk Pool request.
 * @property additionalCapabilities List of additional capabilities for Disk Pool.
 * @property availabilityZones Logical zone for Disk Pool resource; example: ["1"].
 * @property disks List of Azure Managed Disks to attach to a Disk Pool.
 * @property id Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives.
 * @property managedBy Azure resource id. Indicates if this resource is managed by another Azure resource.
 * @property managedByExtended List of Azure resource ids that manage this resource.
 * @property name The name of the resource
 * @property provisioningState State of the operation on the resource.
 * @property status Operational status of the Disk Pool.
 * @property subnetId Azure Resource ID of a Subnet for the Disk Pool.
 * @property systemData Resource metadata required by ARM RPC
 * @property tags Resource tags.
 * @property tier Sku tier
 * @property type The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
 */
public data class GetDiskPoolResult(
    public val additionalCapabilities: List<String>? = null,
    public val availabilityZones: List<String>,
    public val disks: List<DiskResponse>? = null,
    public val id: String,
    public val location: String,
    public val managedBy: String,
    public val managedByExtended: List<String>,
    public val name: String,
    public val provisioningState: String,
    public val status: String,
    public val subnetId: String,
    public val systemData: SystemMetadataResponse,
    public val tags: Map<String, String>? = null,
    public val tier: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storagepool.outputs.GetDiskPoolResult): GetDiskPoolResult = GetDiskPoolResult(
            additionalCapabilities = javaType.additionalCapabilities().map({ args0 -> args0 }),
            availabilityZones = javaType.availabilityZones().map({ args0 -> args0 }),
            disks = javaType.disks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storagepool.kotlin.outputs.DiskResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            location = javaType.location(),
            managedBy = javaType.managedBy(),
            managedByExtended = javaType.managedByExtended().map({ args0 -> args0 }),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            status = javaType.status(),
            subnetId = javaType.subnetId(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.storagepool.kotlin.outputs.SystemMetadataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
